package com.bizunited.platform.core.entity;

import com.bizunited.platform.common.entity.UuidEntity;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.Table;
import java.util.Date;
import java.util.Set;

/**
 * 数据视图分组
 *
 * @author yinwenjie
 */
@Entity
@Table(name = "engine_dataview_group", indexes = {@Index(columnList = "data_source,target_table", unique = true)})
@org.hibernate.annotations.Table(appliesTo = "engine_dataview_group", comment = "数据视图分组")
public class DataViewGroupEntity extends UuidEntity {
  private static final long serialVersionUID = -3134805192098226179L;

  /**
   * 可能的所属数据源编号
   */
  @ManyToOne(fetch = FetchType.LAZY, targetEntity = DataSourceEntity.class)
  @JoinColumn(name = "data_source", columnDefinition = "varchar(255) COMMENT '数据源编号'")
  @SaturnColumn(description = "数据源编号")
  private DataSourceEntity dataSource;

  /**
   * 分组父级
   */
  @ManyToOne(fetch = FetchType.LAZY)
  @SaturnColumn(description = "分组父级")
  @JoinColumn(name = "parent_id", columnDefinition = "varchar(255) COMMENT '分组父级'")
  private DataViewGroupEntity parent;

  /**
   * 数据视图分组新增编码
   */
  @Column(name = "code", length = 255, nullable = false, unique = true)
  @SaturnColumn(description = "数据视图分组新增编码")
  private String code;

  /**
   * 分组名(中文名)
   */
  @Column(name = "group_name", length = 64, columnDefinition = "varchar(64) COMMENT '分组名(中文名)'")
  @SaturnColumn(description = "分组名(中文名)")
  private String groupName;
  /**
   * 基准数据表
   */
  @Column(name = "target_table", length = 64, nullable = false, columnDefinition = "varchar(64) COMMENT '基准数据表'")
  @SaturnColumn(description = "基准数据表")
  private String targetTable;

  /**
   * 创建时间
   */
  @SaturnColumn(description = "创建时间")
  @Column(name = "create_time", nullable = false, columnDefinition = "datetime(3) COMMENT '创建时间'")
  private Date createTime;

  /**
   * 分组子级
   */
  @SaturnColumn(description = "分组子级")
  @OrderBy(" createTime desc")
  @OneToMany(fetch = FetchType.LAZY, mappedBy = "parent")
  private Set<DataViewGroupEntity> children;

  public String getGroupName() {
    return groupName;
  }

  public void setGroupName(String groupName) {
    this.groupName = groupName;
  }

  public String getTargetTable() {
    return targetTable;
  }

  public void setTargetTable(String targetTable) {
    this.targetTable = targetTable;
  }

  public DataSourceEntity getDataSource() {
    return dataSource;
  }

  public void setDataSource(DataSourceEntity dataSource) {
    this.dataSource = dataSource;
  }

  public String getCode() {
    return code;
  }

  public void setCode(String code) {
    this.code = code;
  }

  public DataViewGroupEntity getParent() {
    return parent;
  }

  public void setParent(DataViewGroupEntity parent) {
    this.parent = parent;
  }

  public Date getCreateTime() {
    return createTime;
  }

  public void setCreateTime(Date createTime) {
    this.createTime = createTime;
  }

  public Set<DataViewGroupEntity> getChildren() {
    return children;
  }

  public void setChildren(Set<DataViewGroupEntity> children) {
    this.children = children;
  }
}
