package com.bizunited.platform.core.entity;

import com.bizunited.platform.common.entity.UuidEntity;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.util.Date;

@Entity
@Table(name = "engine_form_sys_theme_file")
@ApiModel(value = "SystemThemeEntity", description = "系统主题文件")
@org.hibernate.annotations.Table(appliesTo = "engine_form_sys_theme_file" , comment = "系统主题文件")
public class SystemThemeEntity extends UuidEntity {
  private static final long serialVersionUID = 1L;

  @Column(name = "commit_user", nullable = false, columnDefinition = "varchar(255) COMMENT '提交人员账号'")
  @ApiModelProperty(name = "commitUser", value = "提交人员账号", required = true)
  @SaturnColumn(description = "提交人员账号")
  private String commitUser;

  @Column(name = "update_user", nullable = false, columnDefinition = "varchar(255) COMMENT '更新人员账号'")
  @ApiModelProperty(name = "updateUser", value = "更新人员账号", required = true)
  @SaturnColumn(description = "更新人员账号")
  private String updateUser;

  @Column(name = "create_time", nullable = false, columnDefinition = "datetime COMMENT '创建时间'")
  @ApiModelProperty(name = "createTime", value = "创建时间", required = true)
  @SaturnColumn(description = "创建时间")
  private Date createTime;

  @Column(name = "update_time", nullable = false, columnDefinition = "datetime COMMENT '更新时间'")
  @ApiModelProperty(name = "updateTime", value = "更新时间", required = true)
  @SaturnColumn(description = "更新时间")
  private Date updateTime;

  @Column(name = "file_name", nullable = true, columnDefinition = "varchar(255) COMMENT '主题重命名后的文件名称'")
  @ApiModelProperty(name = "fileName", value = "主题重命名后的文件名称", required = true)
  @SaturnColumn(description = "主题重命名后的文件名称")
  private String fileName;

  @Column(name = "original_name", nullable = true, columnDefinition = "varchar(255) COMMENT '主题原始文件名称'")
  @ApiModelProperty(name = "originalName", value = "主题原始文件名称", required = true)
  @SaturnColumn(description = "主题原始文件名称")
  private String originalName;

  @Column(name = "relative_local", nullable = true, columnDefinition = "varchar(255) COMMENT '主题相对路径'")
  @ApiModelProperty(name = "relativeLocal", value = "主题相对路径", required = true)
  @SaturnColumn(description = "主题相对路径")
  private String relativeLocal;

  /**
   * 项目名
   */
  @ApiModelProperty("项目名")
  @SaturnColumn(description = "项目名")
  @Column(name = "project_name", length = 128, columnDefinition = "varchar(128) default '' COMMENT '项目名'")
  private String projectName;

  public String getProjectName() {
    return projectName;
  }

  public void setProjectName(String projectName) {
    this.projectName = projectName;
  }

  public Date getUpdateTime() {
    return updateTime;
  }

  public void setUpdateTime(Date updateTime) {
    this.updateTime = updateTime;
  }

  public String getUpdateUser() {
    return updateUser;
  }

  public void setUpdateUser(String updateUser) {
    this.updateUser = updateUser;
  }

  public Date getCreateTime() {
    return createTime;
  }

  public void setCreateTime(Date createTime) {
    this.createTime = createTime;
  }

  public String getCommitUser() {
    return commitUser;
  }

  public void setCommitUser(String commitUser) {
    this.commitUser = commitUser;
  }

  public String getFileName() {
    return fileName;
  }

  public void setFileName(String fileName) {
    this.fileName = fileName;
  }

  public String getOriginalName() {
    return originalName;
  }

  public void setOriginalName(String originalName) {
    this.originalName = originalName;
  }

  public String getRelativeLocal() {
    return relativeLocal;
  }

  public void setRelativeLocal(String relativeLocal) {
    this.relativeLocal = relativeLocal;
  }
}
