package com.bizunited.platform.core.entity;

import com.bizunited.platform.common.entity.UuidEntity;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Column;
import javax.persistence.MappedSuperclass;
import java.util.Date;

/**
 * 在实际建模过程中，我们发现很多模型都需要类似创建人、创建时间、修改人、修改时间这样的设定<br>
 * 为了同时满足多个模型上这样的需求，我们将这部分属性专门提取出来形成UuidOpEntity上层抽象类
 * @author yinwenjie
 */
@MappedSuperclass
public abstract class UuidOpEntity extends UuidEntity {
  /**
   * 
   */
  private static final long serialVersionUID = 7279565457132917600L;
  /**
   * 创建人账号
   */
  @ApiModelProperty(name = "createAccount", value = "创建人账号", required = true)
  @SaturnColumn(description = "创建人账号")
  @Column(name = "create_account", nullable = false, columnDefinition = "varchar(255) COMMENT '创建人账号'")
  private String createAccount;
  /** 
   * 创建时间
   * */
  @ApiModelProperty(name = "createTime", value = "创建时间", required = true)
  @Column(name = "create_time", nullable = false, columnDefinition = "datetime COMMENT '创建时间'")
  @SaturnColumn(description = "创建时间")
  private Date createTime;
  /**
   * 更新人账号
   */
  @ApiModelProperty(name = "modifyAccount", value = "更新人账号", required = true)
  @SaturnColumn(description = "更新人账号")
  @Column(name = "modify_account", nullable = false, columnDefinition = "varchar(255) COMMENT '更新人账号'")
  private String modifyAccount;
  /** 
   * 最后更新时间
   *  */
  @ApiModelProperty(name = "modifyTime", value = "最后更新时间", required = true)
  @Column(name = "modify_time" , columnDefinition = "datetime COMMENT '最后更新时间'")
  @SaturnColumn(description = "最后更新时间")
  private Date modifyTime;
  public Date getCreateTime() {
    return createTime;
  }
  public void setCreateTime(Date createTime) {
    this.createTime = createTime;
  }
  public Date getModifyTime() {
    return modifyTime;
  }
  public void setModifyTime(Date modifyTime) {
    this.modifyTime = modifyTime;
  }
  public String getCreateAccount() {
    return createAccount;
  }
  public void setCreateAccount(String createAccount) {
    this.createAccount = createAccount;
  }
  public String getModifyAccount() {
    return modifyAccount;
  }
  public void setModifyAccount(String modifyAccount) {
    this.modifyAccount = modifyAccount;
  }
}