package com.bizunited.platform.core.entity.log;


import com.bizunited.platform.core.entity.UuidOpEntity;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModel;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.util.Date;

/**
 * 操作日志数据
 * @author yinwenjie
 */
@Entity
@Table(name = "engine_logger_info" , indexes = {@Index(columnList = "op_id,module")})
@ApiModel(value = "LoggerInfoEntity", description = "研发效能平台总日志信息")
public class LoggerInfoEntity extends UuidOpEntity {
  /**
   * 
   */
  private static final long serialVersionUID = 6432157314059962845L;
  /**
   * 日志所属模块
   */
  @Column(name="module" , nullable=false , length=255, columnDefinition = "varchar(255) COMMENT '日志所属模块'")
  @SaturnColumn(description="日志所属模块")
  private String module;
  /**
   * 日志对应的业务数据唯一标识
   */
  @Column(name="op_id" , nullable=false , length=255, columnDefinition = "varchar(255) COMMENT '日志对应的业务数据唯一标识'")
  @SaturnColumn(description="日志对应的业务数据唯一标识")
  private String opId;
  /**
   * 日志操作类型（同模板中的设定）
   */
  @Column(name="type" , nullable=false , length=255, columnDefinition = "varchar(255) COMMENT '日志操作类型（同模板中的设定）'")
  @SaturnColumn(description="日志操作类型（同模板中的设定）")
  private String type;
  /**
   * 日志事件操作时间
   */
  @Column(name="op_time" , nullable=false)
  @SaturnColumn(description="日志事件操作时间")
  private Date opTime;
  /**
   * 操作账号信息（可能匿名）
   */
  @Column(name="account" , nullable=false , length=255, columnDefinition = "varchar(255) COMMENT '操作账号信息（可能匿名）'")
  @SaturnColumn(description="操作账号信息（可能匿名）")
  private String account;
  /**
   * 日志信息描述（来源于模板的信息格式设定）
   */
  @Column(name="msg" , nullable=false , length=255, columnDefinition = "varchar(255) COMMENT '日志信息描述（来源于模板的信息格式设定）'")
  @SaturnColumn(description="日志信息描述（来源于模板的信息格式设定）")
  private String msg;
  /**
   * 本次活动变化对应的日志文件存储相对位置（不包括文件名）
   * 日志文件是一个json内容的文件
   */
  @Column(name="relative_path" , nullable=true , length=255, columnDefinition = "varchar(255) COMMENT '本次活动变化对应的日志文件存储相对位置'")
  @SaturnColumn(description="日志文件存储相对位置")
  private String relativePath;
  /**
   * 存储的日志文件文件名（只有文件名）
   */
  @Column(name="file_name" , nullable=true , length=255, columnDefinition = "varchar(255) COMMENT '存储的日志文件文件名（只有文件名）'")
  @SaturnColumn(description="日志文件文件名")
  private String fileName;
  public String getModule() {
    return module;
  }
  public void setModule(String module) {
    this.module = module;
  }
  public String getOpId() {
    return opId;
  }
  public void setOpId(String opId) {
    this.opId = opId;
  }
  public String getType() {
    return type;
  }
  public void setType(String type) {
    this.type = type;
  }
  public Date getOpTime() {
    return opTime;
  }
  public void setOpTime(Date opTime) {
    this.opTime = opTime;
  }
  public String getAccount() {
    return account;
  }
  public void setAccount(String account) {
    this.account = account;
  }
  public String getMsg() {
    return msg;
  }
  public void setMsg(String msg) {
    this.msg = msg;
  }
  public String getRelativePath() {
    return relativePath;
  }
  public void setRelativePath(String relativePath) {
    this.relativePath = relativePath;
  }
  public String getFileName() {
    return fileName;
  }
  public void setFileName(String fileName) {
    this.fileName = fileName;
  }
}
