package com.bizunited.platform.core.repository;

import com.bizunited.platform.core.entity.CodeRuleEntity;
import com.bizunited.platform.core.repository.internal.CodeRuleRepositoryCustom;

import java.util.Set;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

/**
 * CodeRuleRepository
 *
 * @description:
 * @author: yanwe
 * @date: 12/Jun/2019 14:54
 */
@Repository("CodeRuleRepository")
public interface CodeRuleRepository
    extends JpaRepository<CodeRuleEntity, String>,
        JpaSpecificationExecutor<CodeRuleEntity>,
        CodeRuleRepositoryCustom {
  /**
   * 根据code查询详细
   * @param code
   * @return
   */
  @Query(value ="select cgr from CodeRuleEntity cgr "
      + " left join fetch cgr.script "
      + " where cgr.ruleCode = :code")
  CodeRuleEntity findDetailByCode(@Param("code") String code);

  /**
   * 根据code查询
   * @param code
   * @return
   */
  CodeRuleEntity findByRuleCode(String code);

  /**
   * 根据name查询
   * @param name
   * @return
   */
  CodeRuleEntity findByRuleName(String name);
  /**
   * 按照指定的业务编码规则的多个ID信息，查询基本信息和关联信息
   * @param ids
   * @return
   */
  @Query(value ="select cgr from CodeRuleEntity cgr "
      + " left join fetch cgr.script "
      + " where cgr.id in (:ids)")
  Set<CodeRuleEntity> findDetailsByIds(@Param("ids") String[] ids);
  /**
   * 按照指定的业务编码规则的ID信息，查询最终满足这些id编号的数据条目。<br>
   * 这个方法一般用于验证一批给定的id，是否都能在系统中找到对应的数据
   * @param ids 指定的id信息
   * @return 满足的条目数量将会被返回
   */
  @Query(value="select count(id) from engine_code_rule where engine_code_rule.id in (:ids)" , nativeQuery = true)
  int countByIds(@Param("ids") String[] ids);

  /**
   * 根据名称统计，并排除ID
   * @param name
   * @param id
   * @return
   */
  @Query("select count(*) from CodeRuleEntity cr where cr.ruleName = :name and cr.id not in (:id)")
  long countByRuleNameWithoutId(@Param("name") String name, @Param("id") String id);
}
