package com.bizunited.platform.core.repository;

import com.bizunited.platform.core.entity.DataSourceTableEntity;
import com.bizunited.platform.core.repository.internal.DataSourceTableRepositoryCustom;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * @Author: Paul Chan
 * @Date: 2019-04-15 10:59
 * @Description:
 */
@Repository("DataSourceTableRepository")
public interface DataSourceTableRepository extends
    JpaRepository<DataSourceTableEntity, String>
    , JpaSpecificationExecutor<DataSourceTableEntity>,
    DataSourceTableRepositoryCustom {


  /**
   * 根据数据源查询数据表信息
   * @param dataSourceId
   * @return
   */
  @Query("select dtt from DataSourceTableEntity dtt join dtt.dataSource dse where dse.id = :dataSourceId")
  List<DataSourceTableEntity> findByDataSource(@Param("dataSourceId") String dataSourceId);

  /**
   * 查询主数据源的表信息
   * @return
   */
  @Query("from DataSourceTableEntity dtt where dtt.dataSource is null")
  List<DataSourceTableEntity> findMainDataSourceTables();

  /**
   * 根据表名获取主数据源的表信息
   * @param tableName
   * @return
   */
  @Query("from DataSourceTableEntity dtt where dtt.dataSource is null and dtt.tableName = :tableName")
  DataSourceTableEntity findMainDataSourceTableByTableName(@Param("tableName") String tableName);

  /**
   * 根据表名和数据源查询数据表信息
   * @param tableName
   * @param dataSourceId
   * @return
   */
  @Query("select dtt from DataSourceTableEntity dtt join dtt.dataSource ds where ds.id = :dataSourceId and dtt.tableName = :tableName")
  DataSourceTableEntity findByTableNameAndDataSource(@Param("tableName") String tableName, @Param("dataSourceId") String dataSourceId);
}
