package com.bizunited.platform.core.repository;

import com.bizunited.platform.core.entity.SystemThemeEntity;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import java.util.List;


@Repository
public interface SystemThemeRepository extends
    JpaRepository<SystemThemeEntity, String>,
    JpaSpecificationExecutor<SystemThemeEntity> {

  /**
   * 根据相对路径与文件名，查询主题实体信息
   * @param relativeLocal
   * @param fileName
   * @return
   */
  @Query("from SystemThemeEntity th where th.relativeLocal = :relativeLocal and th.fileName = :fileName")
  public SystemThemeEntity findByRelativeLocalAndFileName(@Param("relativeLocal") String relativeLocal , @Param("fileName") String fileName);

  /**
   * 根据项目名查询主题
   * @param projectName
   * @return
   */
  @Query("select st from SystemThemeEntity st where st.projectName = :projectName")
  List<SystemThemeEntity> findByProjectName(@Param("projectName") String projectName);

  /**
   * 根据空项目名查询主题
   * @return
   */
  @Query("select st from SystemThemeEntity st where st.projectName = '' OR st.projectName IS NULL")
  List<SystemThemeEntity> findByBlankProjectName();

}
