package com.bizunited.platform.core.repository.dataview;

import com.bizunited.platform.core.entity.DataViewAuthEntity;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import java.util.Set;

/**
 * 数据视图权限的持久化接口定义
 *
 * @Author: Paul Chan
 * @Date: 2020-04-23 11:17
 */
@Repository("DataViewAuthRepository")
public interface DataViewAuthRepository extends JpaRepository<DataViewAuthEntity, String>, JpaSpecificationExecutor<DataViewAuthEntity> {

  /**
   * 根据编码统计查询
   *
   * @param code
   * @return
   */
  @Query("select count(*) from DataViewAuthEntity a where a.code = :code")
  long countByCode(@Param("code") String code);

  /**
   * 根据编码并排除id统计查询
   *
   * @param code
   * @return
   */
  @Query("select count(*) from DataViewAuthEntity a where a.code = :code and a.id <> :id")
  long countByCodeExcludeId(@Param("code") String code, @Param("id") String id);

  /**
   * 根据编码查询详情
   * @param code
   * @return
   */
  @Query("select a from DataViewAuthEntity a " +
      " left join fetch a.dataView adv " +
      " where a.code = :code")
  DataViewAuthEntity findDetailsByCode(@Param("code") String code);

  /**
   * 根据数据视图编码获取权限
   * @param dataViewCode
   * @return
   */
  @Query("select a from DataViewAuthEntity a inner join a.dataView dv where dv.code = :dataViewCode order by a.createTime desc")
  Set<DataViewAuthEntity> findByDataViewCode(@Param("dataViewCode") String dataViewCode);

  /**
   * 根据数据视图编码和权限编码获取权限
   * @param dataViewCode
   * @param code
   * @return
   */
  @Query("select a from DataViewAuthEntity a " +
      " inner join fetch a.dataView dv " +
      " where dv.code = :dataViewCode " +
      " and a.code = :code " +
      " order by a.createTime desc")
  DataViewAuthEntity findDetailsByDataViewCodeAndCode(@Param("dataViewCode") String dataViewCode, @Param("code") String code);

  /**
   * 根据数据视图ID集合查询详情
   * @param code
   * @return
   */
  @Query("select a from DataViewAuthEntity a " +
      " inner join fetch a.dataView adv " +
      " where adv.id in :dataviewIds")
  Set<DataViewAuthEntity> findDetailsByDataViewIds(@Param("dataviewIds") String[] dataviewIds);
}
