package com.bizunited.platform.core.repository.dataview;

import com.bizunited.platform.core.entity.DataViewAuthVerticalRelationEntity;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import javax.transaction.Transactional;
import java.util.Set;

/**
 * DataViewAuthVerticalRelationEntity业务模型的数据库方法支持
 * @author saturn
 */
@Repository("_DataViewAuthVerticalRelationRepository")
public interface DataViewAuthVerticalRelationRepository
    extends
      JpaRepository<DataViewAuthVerticalRelationEntity, String>
      ,JpaSpecificationExecutor<DataViewAuthVerticalRelationEntity>
  {
  /**
   * 按照纵向数据权限进行详情查询（包括关联信息），这里查询的是
   * @param authVerticalId 纵向数据权限
   * */
  @Query("select distinct dataViewAuthVerticalRelationEntity from DataViewAuthVerticalRelationEntity dataViewAuthVerticalRelationEntity "
      + " left join fetch dataViewAuthVerticalRelationEntity.authVertical dataViewAuthVerticalRelationEntity_authVertical "
       + " where dataViewAuthVerticalRelationEntity_authVertical.id = :authVerticalId")
  public Set<DataViewAuthVerticalRelationEntity> findDetailsByAuthVertical(@Param("authVerticalId") String authVerticalId);

  /**
   * 按照主键进行详情查询（包括关联信息），这里查询的是
   * @param id 主键
   * */
  @Query("select distinct dataViewAuthVerticalRelationEntity from DataViewAuthVerticalRelationEntity dataViewAuthVerticalRelationEntity "
      + " left join fetch dataViewAuthVerticalRelationEntity.authVertical dataViewAuthVerticalRelationEntity_authVertical "
      + " where dataViewAuthVerticalRelationEntity.id=:id ")
  public DataViewAuthVerticalRelationEntity findDetailsById(@Param("id") String id);

    /**
     * 根据纵向权限信息id删除信息
     * @param authVerticalId
     */
  @Modifying
  @Transactional
  @Query(value = "delete from engine_dataview_auth_vertical_relation where auth_vertical = :authVerticalId",nativeQuery = true)
  public void deleteByAuthVertical(@Param("authVerticalId") String authVerticalId);
  }