package com.bizunited.platform.core.repository.dataview;

import com.bizunited.platform.core.entity.DataViewAuthEntity;
import com.bizunited.platform.core.entity.DataViewAuthVerticalEntity;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import java.util.Set;

/**
 * DataViewAuthVerticalEntity业务模型的数据库方法支持
 *
 * @author saturn
 */
@Repository("_DataViewAuthVerticalRepository")
public interface DataViewAuthVerticalRepository
    extends
    JpaRepository<DataViewAuthVerticalEntity, String>
    , JpaSpecificationExecutor<DataViewAuthVerticalEntity> {


  /**
   * 按照主键进行详情查询（包括关联信息），这里查询的是
   *
   * @param id 主键
   */
  @Query("select distinct av from DataViewAuthVerticalEntity av "
      + " left join fetch av.authRelations avr "
      + " where av.id=:id ")
  DataViewAuthVerticalEntity findDetailsById(@Param("id") String id);

  /**
   * 根据数据权限查询纵向权限信息
   * @param dataViewAuth
   */
  @Query("select av from DataViewAuthVerticalEntity av where av.dataViewAuth = :dataViewAuth order by av.sortIndex asc")
  Set<DataViewAuthVerticalEntity> findByAuth(@Param("dataViewAuth") DataViewAuthEntity dataViewAuth);
}