package com.bizunited.platform.core.repository.dataview;

import com.bizunited.platform.core.entity.DataViewSystemEntity;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;
import java.util.List;

/**
 * DataViewSystemEntity业务模型的数据库方法支持
 * @author saturn
 */
@Repository("_DataViewSystemRepository")
public interface DataViewSystemRepository
    extends
      JpaRepository<DataViewSystemEntity, String>
      ,JpaSpecificationExecutor<DataViewSystemEntity>
  {
  /**
   * 按照对应的视图进行查询
   * @param dataViewId 对应的视图
   */
  @Query("from DataViewSystemEntity dataViewSystemEntity " 
      + " left join fetch dataViewSystemEntity.dataView dataView " 
      + " where dataView.id = :dataViewId")
  public List<DataViewSystemEntity> findByDataView(@Param("dataViewId") String dataViewId);

  /**
   * 按照主键进行详情查询（包括关联信息），这里查询的是
   * @param id 主键
   * */
  @Query("select distinct dataViewSystemEntity from DataViewSystemEntity dataViewSystemEntity "
      + " left join  fetch dataViewSystemEntity.dataView dataViewSystemEntity_dataView "
      + " where dataViewSystemEntity.id=:id ")
  public DataViewSystemEntity findDetailsById(@Param("id") String id);

  @Modifying
  @Query("delete from DataViewSystemEntity sys where sys.id = :id")
  public void deleteById(@Param("id") String id);
}