package com.bizunited.platform.core.repository.dataview;

import com.bizunited.platform.core.repository.dynamic.DynamicDataSourceManager;
import org.apache.commons.lang3.Validate;
import org.hibernate.SessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.orm.hibernate5.SessionFactoryUtils;
import org.springframework.stereotype.Repository;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;

/**
 * 第三方数据视图数据查询
 */
@Repository("DataViewThirdDataSourceRepositoryImpl")
public class DataViewThirdDataSourceRepositoryImpl implements DataViewThirdDataSourceRepository {
  @Autowired
  private DynamicDataSourceManager dynamicDataSourceManager;
  private static final String ERROR_SQL = "SQL执行异常，请检查!!详情：";


  
  /**
   * 检查第三方数据源中基础表是否存在
   */
  @Override
  public void checkTable(String dataSourceCode, String tableName) {
    Validate.notBlank(tableName,"输入数据表名不能为空，请检查！");
    Validate.notBlank(dataSourceCode,"输入第三方数据源编码不能为空，请检查！");
    SessionFactory sessionFactory = this.dynamicDataSourceManager.getCurrentSessionFactory(dataSourceCode);
    try (Connection connection = SessionFactoryUtils.getDataSource(sessionFactory).getConnection();) {
      DatabaseMetaData md = connection.getMetaData();
      try(ResultSet rs = md.getTables(null, null, tableName, null);){
        Validate.isTrue(rs.next(),"所设置第三方数据源中基础表不存在，请检查！");
      }
    } catch (Exception e){
      throw new IllegalArgumentException(ERROR_SQL+e.getMessage());
    }
  }
}
