package com.bizunited.platform.core.repository.dataview.analysis;

import com.bizunited.platform.core.entity.DataViewAuthEntity;
import com.bizunited.platform.core.entity.DataViewAuthInterceptorEntity;
import com.bizunited.platform.core.service.dataview.executor.InterceptorExecutor;
import com.bizunited.platform.core.service.dataview.model.ExecuteContextModel;
import org.springframework.util.CollectionUtils;

import java.util.Set;

/**
 * sql处理的抽象类，主要用于sql的通用处理，如sql的条件等
 * @Author: Paul Chan
 * @Date: 2019-10-09 17:08
 */
public abstract class AbstractSqlAnalysis implements SqlAnalysis {

  protected static final String ERROR_SQL = "SQL执行传入的的参数";

  /**
   * sql执行的上下文
   */
  protected ExecuteContextModel executeContext;

  public AbstractSqlAnalysis(ExecuteContextModel executeContext){
    this.executeContext = executeContext;
  }

  @Override
  public void analysis() {
    executeContext.setExecuteSql(executeContext.getDataView().getSourceSql());
    SQLAuthVerticalAnalysis.buildSQLAuthVertical(executeContext);
    SQLSystemParamAnalysis.buildSystemParamAnalysis(executeContext);
    SQLConditionFilterAnalysis.buildSQLConditions(executeContext);
    SQLAuthHorizontalAnalysis.buildSQLAuthHorizoncal(executeContext);
    this.interceptor();
    SQLOrderbyAnalysis.buildOrderBy(executeContext);
    this.pageAnalysis();
  }

  abstract void pageAnalysis();

  /**
   * 执行拦截器
   */
  protected void interceptor() {
    DataViewAuthEntity dataViewAuth = executeContext.getDataViewAuth();
    if(dataViewAuth == null) {
      return;
    }
    Set<DataViewAuthInterceptorEntity> interceptors = dataViewAuth.getInterceptors();
    if(CollectionUtils.isEmpty(interceptors)) {
      return;
    }
    new InterceptorExecutor(executeContext, interceptors).execute();
  }




}
