package com.bizunited.platform.core.repository.dataview.analysis;

import com.bizunited.platform.core.service.dataview.model.ExecuteContextModel;
import com.bizunited.platform.core.service.dataview.model.PageableModel;
import org.apache.commons.lang3.StringUtils;

import static com.bizunited.platform.core.repository.dataview.analysis.Constants.ALIAS_STRING2;
import static com.bizunited.platform.core.repository.dataview.analysis.Constants.ALIAS_STRING3;

/**
 * 实现oracle的sql分析，在执行sql前，对sql进行分页、参数、权限等处理
 *
 * @Author: Paul Chan
 * @Date: 2019-10-09 16:58
 */
public class OracleSqlAnalysis extends AbstractSqlAnalysis {


  public OracleSqlAnalysis(ExecuteContextModel executeContext) {
    super(executeContext);
  }

  /**
   * 分页处理
   */
  protected void pageAnalysis() {
    PageableModel pageable = executeContext.getExecuteParam().getPageable();
    if (pageable == null) {
      return;
    }
    //两部分解析
    //1.先解析count语句
    String executeSql = executeContext.getExecuteSql();
    String countSQL = String.format("select count(*) from (%s) a", executeSql);
    // 不包含开始行目
    int start = pageable.getPage() * pageable.getSize();
    // 包含结束行目
    int end = (pageable.getPage() + 1) * pageable.getSize();
    executeSql = String.format("select * from (select %s.*,ROWNUM RN from (%s) %s where ROWNUM <= ?) %s where RN > ?", ALIAS_STRING2, executeSql, ALIAS_STRING2, ALIAS_STRING3);
    executeContext.setExecuteSql(executeSql);
    executeContext.addExecuteCountSqlParameters(executeContext.getExecuteSqlParameters());
    executeContext.addExecuteSqlParameter(end);
    executeContext.addExecuteSqlParameter(start);
    executeContext.setExecuteCountSql(countSQL);
  }

  @Override
  public String concatSql(String... strs) {
    if (strs == null || strs.length == 0) {
      return Constants.EMPTY_CHAR;
    }
    return StringUtils.join(strs, "||");
  }

}
