package com.bizunited.platform.core.repository.dataview.analysis;

import com.bizunited.platform.core.entity.DataViewFieldEntity;
import com.bizunited.platform.core.service.dataview.model.ExecuteContextModel;
import com.bizunited.platform.core.service.dataview.model.ExecuteParamModel;
import com.bizunited.platform.core.service.dataview.model.SortModel;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.data.domain.Sort;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

class SQLOrderbyAnalysis {

  private SQLOrderbyAnalysis() {
    throw new IllegalStateException("静态类不能进行实例化");
  }

  /**
   * 构建sql的排序
   * @param executeContext
   */
  public static void buildOrderBy(ExecuteContextModel executeContext) {
    ExecuteParamModel executeParam = executeContext.getExecuteParam();
    SortModel sort = executeParam.getSort();
    if(sort == null) {
      return;
    }
    List<SortModel.OrderModel> orders = sort.getOrders();
    if(CollectionUtils.isEmpty(orders)) {
      return;
    }
    Set<DataViewFieldEntity> fields = executeContext.getDataViewFields();
    Validate.notNull(fields, "数据视图的字段为空");
    Set<String> fieldSet = fields.stream().map(DataViewFieldEntity::getFieldName).collect(Collectors.toSet());
    List<String> orderBys = new ArrayList<>();
    String sqlAlias = executeContext.getWrapperSqlAlias();
    for (SortModel.OrderModel order : orders) {
      String property = order.getProperty();
      Validate.notBlank(property, "排序字段不能为空");
      Validate.isTrue(fieldSet.contains(property), "未找到排序字段：%s", property);
      Sort.Direction direction = order.getDirection();
      if(direction == null) {
        direction = Sort.Direction.ASC;
      }
      orderBys.add(String.format(" %s.%s %s ", sqlAlias, property, direction.name()));
    }
    String sorts = StringUtils.join(orderBys, ",");
    String orderBy = String.format(" order by %s ", sorts);
    executeContext.appendExecuteSql(orderBy);
  }

}
