package com.bizunited.platform.core.repository.internal;

import com.bizunited.platform.core.entity.DataSourceTableEntity;
import org.hibernate.SessionFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Repository;

import java.util.Set;

/**
 * @Author: Paul Chan
 * @Date: 2019-04-10 14:59
 * @Description:
 */
@Repository("DataSourceTableRepositoryCustom")
public interface DataSourceTableRepositoryCustom {


  /**
   * 根据条件分页查询
   * @param pageable
   * @param tableType
   * @param dataSourceId
   * @param status
   * @param tableName
   * @return
   */
  Page<DataSourceTableEntity> findByConditions(Pageable pageable, Integer tableType, String dataSourceId, Integer status, String tableName);

  /**
   * 获取主数据源的表
   * @return
   */
  Set<String> queryMainDataSourceTables();


  /**
   * 获取第三方数据源的表
   * @param sessionFactory
   * @return
   */
  Set<String> queryDataSourceTables(SessionFactory sessionFactory);
}
