package com.bizunited.platform.core.repository.internal;

import com.bizunited.platform.common.repository.PageRepositoryImpl;
import com.bizunited.platform.core.entity.log.LoggerInfoEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import java.util.HashMap;
import java.util.Map;

/**
 * LoggerInfoEntityRepositoryCustomImpl
 *
 * @description:
 * @author: chengzhongxiang
 * @date: 18/August/2020 10:50
 */
public class LoggerInfoEntityRepositoryCustomImpl implements LoggerInfoEntityRepositoryCustom, PageRepositoryImpl {
  @Autowired
  @PersistenceContext
  private EntityManager entityManager;
  private static final String OPID = "opId";
  private static final String MODULE = "module";
  @Override
  public Page<LoggerInfoEntity> findByConditions(Pageable pageable, Map<String, Object> conditions) {
    StringBuilder hql = new StringBuilder("from LoggerInfoEntity lie  where 1 = 1");
    StringBuilder countHql = new StringBuilder("select count(*) from LoggerInfoEntity lie where 1 = 1");
    StringBuilder condition=new StringBuilder();
    Map<String,Object> parameter=new HashMap<>(2);
    Object opId = conditions.get(OPID);
    if(opId!=null){
        condition.append(" AND lie.opId like CONCAT('%',:opId,'%')");
        parameter.put("opId",opId);
    }
    Object module = conditions.get(MODULE);
    if(module!=null){
        condition.append(" AND lie.module like CONCAT('%',:module,'%')");
        parameter.put("module",module);
    }
    hql.append(condition).append("order by lie.opTime DESC");
    countHql.append(condition);
    return queryByConditions(entityManager,hql.toString(),countHql.toString(),parameter,pageable,false,null);
  }
}
