package com.bizunited.platform.core.repository.log;

import com.bizunited.platform.core.entity.log.LoggerFiledMappingEntity;
import com.bizunited.platform.core.repository.internal.LoggerFiledMappingEntityRepositoryCustom;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * LoggerFiledMappingEntity业务模型的数据库方法支持
 * @author saturn
 */
@Repository("_LoggerFiledMappingEntityRepository")
public interface LoggerFiledMappingEntityRepository
    extends
      JpaRepository<LoggerFiledMappingEntity, String>
      ,JpaSpecificationExecutor<LoggerFiledMappingEntity>
      , LoggerFiledMappingEntityRepositoryCustom
{

    /**
     * 查询字段中文描述信息
     * @param applicationName
     * @param fieldName
     * @return
     */
  @Query("select distinct f from LoggerFiledMappingEntity f where f.applicationName = :applicationName and f.fieldName = :fieldName")
  List<LoggerFiledMappingEntity> findByApplicationNameAndFieldName(@Param("applicationName") String applicationName, @Param("fieldName") String fieldName);
  /**
   * 根据应用名查询
   *
   * @param applicationName
   * @return
   */
  LoggerFiledMappingEntity findByApplicationName(String applicationName);
  /**
   * 根据英文字段名查询
   *
   * @param fieldName
   * @return
   */
  LoggerFiledMappingEntity findByFieldName(String fieldName);
}