package com.bizunited.platform.core.repository.log;

import com.bizunited.platform.core.entity.log.LoggerTemplateEntity;
import com.bizunited.platform.core.repository.internal.LoggerTemplateEntityRepositoryCustom;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

/**
 * LoggerTemplateEntity业务模型的数据库方法支持
 * @author saturn
 */
@Repository("_LoggerTemplateEntityRepository")
public interface LoggerTemplateEntityRepository
    extends
      JpaRepository<LoggerTemplateEntity, String>
      ,JpaSpecificationExecutor<LoggerTemplateEntity>
      , LoggerTemplateEntityRepositoryCustom
{

  /**
   * 按照主键进行详情查询（包括关联信息）
   * @param id 主键
   * */
  @Query("select distinct loggerTemplateEntity from LoggerTemplateEntity loggerTemplateEntity "
      + " where loggerTemplateEntity.id=:id ")
  LoggerTemplateEntity findDetailsById(@Param("id") String id);
  /**
   * 按照模板编号，唯一的编号，必须有进行查询
   * @param code 模板编号，唯一的编号，必须有
   * */
  @Query(" from LoggerTemplateEntity f where f.code = :code")
  LoggerTemplateEntity findByCode(@Param("code") String code);
  /**
   * 按照完整的被拦截的方法名进行查询
   * @param methodName 完整的被拦截的方法名
   * */
  @Query(" from LoggerTemplateEntity f where f.methodName = :methodName")
  LoggerTemplateEntity findByMethodName(@Param("methodName") String methodName);

}