package com.bizunited.platform.core.repository.migrate;

import com.bizunited.platform.core.entity.MigrateImportEntity;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * MigrateImportRepository
 *
 * @description:
 * @author: yanwe
 * @date: 03/Sep/2019 15:32
 */
@Repository
public interface MigrateImportRepository extends JpaRepository<MigrateImportEntity, String>,
    JpaSpecificationExecutor<MigrateImportEntity> {

  /**
   * 根据数据类型查询(有项目名)
   *
   * @param dataType
   * @return
   */
  @Query("select mi from com.bizunited.platform.core.entity.MigrateImportEntity mi where mi.dataType = :dataType and mi.projectName = :projectName order by mi.createTime desc")
  List<MigrateImportEntity> findByDataTypeAndProjectName(@Param("dataType") Integer dataType, @Param("projectName") String projectName);

  /**
   * 根据ID查询详情
   * @param id
   * @return
   */
  @Query("select mi from com.bizunited.platform.core.entity.MigrateImportEntity mi left join fetch mi.detail where mi.id = :id")
  MigrateImportEntity findDetailsById(@Param("id") String id);

  /**
   * 根据数据类型查询(无项目名)
   *
   * @param dataType
   * @return
   */
  @Query("select mi from com.bizunited.platform.core.entity.MigrateImportEntity mi where mi.dataType = :dataType and (mi.projectName = '' OR mi.projectName IS NULL ) order by mi.createTime desc")
  List<MigrateImportEntity> findByDataTypeAndBlankProjectName(@Param("dataType") Integer dataType);
}
