package com.bizunited.platform.core.repository.script;

import com.bizunited.platform.common.repository.PageRepositoryImpl;
import com.bizunited.platform.core.entity.ScriptEntity;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Repository;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import java.util.HashMap;
import java.util.Map;

import static com.bizunited.platform.common.constant.Constants.PROJECT_NAME;

@Repository("ScriptRepositoryImpl")
public class ScriptRepositoryImpl implements ScriptRepositoryCustom, PageRepositoryImpl {

  @Autowired
  @PersistenceContext
  private EntityManager entityManager;
  private static final String MESS_LANGUAGE = "language";
  private static final String MESS_NAME = "name";

  @Override
  public Page<ScriptEntity> queryPage(Pageable pageable, Map<String, Object> conditions) {

    /*
     * -目前的查询条件是：表单名、业务领域、项目名
     * */
    StringBuilder hql = new StringBuilder("from ScriptEntity script where 1=1");
    StringBuilder countHql = new StringBuilder("select count(*) from ScriptEntity script where 1=1");
    StringBuilder condition = new StringBuilder();
    Map<String, Object> parameters = new HashMap<>();

    // 表单名name
    Object name = conditions.get(MESS_NAME);
    if(name != null) {
      condition.append(" AND script.name = :name ");
      parameters.put(MESS_NAME, name);
    }

    // 表单名name
    Object language = conditions.get(MESS_LANGUAGE);
    if(language != null) {
      condition.append(" AND script.language = :language ");
      parameters.put(MESS_LANGUAGE, language);
    }

    //项目名
    String projectName = (String) conditions.get(PROJECT_NAME);
    if(StringUtils.isNotBlank(projectName)) {
      condition.append(" AND script.projectName = :projectName ");
      parameters.put(PROJECT_NAME, projectName);
    }else {
    condition.append(" AND (script.projectName = '' OR script.projectName IS NULL)");
  }

    hql.append(condition);
    countHql.append(condition);
    return queryByConditions(entityManager, hql.toString(), countHql.toString(), parameters, pageable, false, null);
  }
}
