package com.bizunited.platform.core.service;

import com.bizunited.platform.common.model.MigrateImportModel;
import com.bizunited.platform.core.entity.EnvironmentVariableEntity;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

import java.util.List;
import java.util.Set;

/**
 * EnvironmentVariableService
 *
 * @description:
 * @author: yanwe
 * @date: 15/May/2019 14:33
 */
public interface EnvironmentVariableService {

  /**
   * 根据条件查询分页
   * @param paramCode
   * @param paramKey
   * @param paramValue
   * @param paramType
   * @param paramStatus
   * @param pageable
   * @return
   */
  Page<EnvironmentVariableEntity> findByConditions(String paramCode, String paramKey, String paramValue, String paramType, Integer paramStatus, Pageable pageable);
  /**
   * 查询所有
   *
   * @return
   */
  List<EnvironmentVariableEntity> findAll();
  /**
   * 根据键查找
   *
   * @param key
   * @return
   */
  EnvironmentVariableEntity findByKey(String key);
  /**
   * 根据业务编码信息查询环境变量设定
   * @param code 全系统唯一的业务编码
   * @return 
   */
  EnvironmentVariableEntity findByCode(String code);
  /**
   * 根据一个或者多个ID信息查询环境变量设定的基本信息和关联信息
   * @param ids
   * @return
   */
  Set<EnvironmentVariableEntity> findDetailsByIds(String[] ids);
  /**
   * 按照指定的全局变量的ID信息，查询最终满足这些id编号的数据条目。<br>
   * 这个方法一般用于验证一批给定的id，是否都能在系统中找到对应的数据
   * @param ids 指定的id信息
   * @return 满足的条目数量将会被返回
   */
  long countByIds(String[] ids);
  /**
   * 启用
   * @param id
   * @return
   */
  EnvironmentVariableEntity enable(String id);
  /**
   * 禁用
   * @param id
   * @return
   */
  EnvironmentVariableEntity disable(String id);
  /**
   * 新增/更新
   *
   * @param environmentVariableEntity
   * @return
   */
  EnvironmentVariableEntity save(EnvironmentVariableEntity environmentVariableEntity);
  /**
   * 删除
   *
   * @param id
   */
  void delete(String id);

  /**
   * 导入全局变量
   * @param importModel
   */
  void importData(MigrateImportModel importModel);

  /**
   * 不分页查询
   * @param paramCode
   * @param paramKey
   * @param paramType
   * @param paramStatus
   * @return
   */
  List<EnvironmentVariableEntity> findAllByConditions(String paramCode, String paramKey, String paramType, Integer paramStatus);
}
