package com.bizunited.platform.core.service.dataview;

import com.bizunited.platform.core.entity.DataViewAuthHorizontalEntity;

import java.util.Set;

/**
 * DataViewAuthHorizontalEntity业务模型的服务层接口定义
 *
 * @author saturn
 */
public interface DataViewAuthHorizontalService {

  /**
   * 保存横向权限对象集合
   */
  Set<DataViewAuthHorizontalEntity> save(String authId, Set<DataViewAuthHorizontalEntity> authHorizontals);

  /**
   * 按照主键进行详情查询（包括关联信息）
   *
   * @param id 主键
   */
  DataViewAuthHorizontalEntity findDetailsById(String id);

  /**
   * 按照DataViewAuthHorizontalEntity的主键编号，查询指定的数据信息（不包括任何关联信息）
   *
   * @param id 主键
   */
  DataViewAuthHorizontalEntity findById(String id);

  /**
   * 按照主键进行信息的真删除
   *
   * @param id 主键
   */
  void deleteById(String id);

  /**
   * 根据权限ID查询横向权限
   * @param authId
   * @return
   */
  Set<DataViewAuthHorizontalEntity> findDetailsByAuthId(String authId);

  /**
   * 根据字段名删除对应的权限
   * @param fieldName
   */
  void deleteByField(String fieldName);

  /**
   * 根据权限ID删除横向权限
   * @param authId
   */
  void deleteByAuthId(String authId);
}