package com.bizunited.platform.core.service.dataview;

import com.bizunited.platform.core.entity.DataViewAuthVerticalEntity;

import java.util.Set;

/**
 * DataViewAuthVerticalEntity业务模型的服务层接口定义
 *
 * @author saturn
 */
public interface DataViewAuthVerticalService {

  /**
   * 保存数据视图纵向权限
   * @param authId
   * @param authVerticals
   * @return
   */
  Set<DataViewAuthVerticalEntity> save(String authId, Set<DataViewAuthVerticalEntity> authVerticals);

  /**
   * 按照主键进行详情查询（包括关联信息）
   *
   * @param id 主键
   */
  DataViewAuthVerticalEntity findDetailsById(String id);

  /**
   * 按照DataViewAuthVerticalEntity的主键编号，查询指定的数据信息（不包括任何关联信息）
   *
   * @param id 主键
   */
  DataViewAuthVerticalEntity findById(String id);

  /**
   * 按照主键进行信息的真删除
   *
   * @param id 主键
   */
  void deleteById(String id);

  /**
   * 根据权限编码查询纵向权限详情
   * @param authId
   * @return
   */
  Set<DataViewAuthVerticalEntity> findDetailsByAuthId(String authId);

  /**
   * 根据权限ID删除纵向权限
   * @param authId
   */
  void deleteByAuthId(String authId);
}