package com.bizunited.platform.core.service.dataview;

import com.bizunited.platform.core.entity.DataViewEntity;
import com.bizunited.platform.core.entity.DataViewSystemEntity;

import java.util.List;
import java.util.Set;

/**
 * DataViewSystemEntity业务模型的服务层接口定义
 * @author saturn
 */
public interface DataViewSystemService {
  /**
   * 在创建一个新的DataViewSystemEntity模型对象之前，检查对象各属性的正确性，其主键属性必须没有值
   */
  public void createValidation(DataViewSystemEntity dataViewSystemEntity);
  /**
   * 创建一个新的DataViewSystemEntity模型对象，ignoreValidate参数表示是否在进行创建前进行属性验证
   */
  public DataViewSystemEntity create(DataViewSystemEntity dataViewSystemEntity, boolean ignoreValidate);
  /**
   * 更新一个已有的DataViewSystemEntity模型对象，其主键属性必须有值
   */
  public DataViewSystemEntity update(DataViewSystemEntity dataViewSystemEntity);
  /**
   * 在更新一个已有的DataViewSystemEntity模型对象之前，检查对象各属性的正确性，其id属性必须有值
   */
  public void updateValidation(DataViewSystemEntity dataViewSystemEntity);
  /**
   * 按照对应的视图查询DataViewSystemEntity
   */
  public List<DataViewSystemEntity> findByDataView(String dataViewId);
  /**t
   * 按照主键进行详情查询（包括关联信息）
   * @param id 主键
   */
  public DataViewSystemEntity findDetailsById(String id);
  /**
   *  按照主键进行信息的真删除 
   * @param id 主键 
   */
  public void deleteById(String id);

  /**
   * 创建一个新的DataViewSystemEntity模型集合
   * @param systemFilters
   * @param dataViewEntity
   */
  void create(Set<DataViewSystemEntity> systemFilters, DataViewEntity dataViewEntity);

  /**
   * 更新系统参数
   * @param dataView
   * @param systemFilters
   * @return
   */
  Set<DataViewSystemEntity> update(DataViewEntity dataView, Set<DataViewSystemEntity> systemFilters);
}