package com.bizunited.platform.core.service.dataview.model;

import com.bizunited.platform.core.common.enums.DataSourceTypeEnum;
import com.bizunited.platform.core.entity.DataSourceEntity;
import com.bizunited.platform.core.entity.DataViewAuthEntity;
import com.bizunited.platform.core.entity.DataViewEntity;
import com.bizunited.platform.core.entity.DataViewFieldEntity;
import com.bizunited.platform.core.entity.DataViewFilterEntity;
import com.bizunited.platform.core.entity.DataViewSystemEntity;
import com.bizunited.platform.core.repository.dataview.analysis.SQLPresetValueAnalysis;
import com.bizunited.platform.core.repository.dataview.analysis.SqlAnalysis;
import org.springframework.context.ApplicationContext;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;

/**
 * 数据视图执行的上线文信息,此模型贯穿数据视图执行的始终
 * @Author: Paul Chan
 * @Date: 2020-04-17 14:51
 */
public class ExecuteContextModel {

  /**
   * spring 上下文
   */
  private ApplicationContext applicationContext;

  /**
   * 数据源类型
   */
  private DataSourceTypeEnum dataSourceType;

  /**
   * 数据源，如果为null，则表示是主数据源
   */
  private DataSourceEntity dataSource;

  /**
   * 数据视图信息
   */
  private DataViewEntity dataView;

  /**
   * 执行的相关参数信息
   */
  private ExecuteParamModel executeParam;

  /**
   * sql生成器
   */
  private SqlAnalysis sqlAnalysis;

  /**
   * 数据视图字段
   */
  private Set<DataViewFieldEntity> dataViewFields;

  /**
   * 筛选字段信息
   */
  private Set<DataViewFilterEntity> dataViewFilters;

  /**
   * 系统参数
   */
  private Set<DataViewSystemEntity> systemFilters;

  /**
   * 数据权限
   */
  private DataViewAuthEntity dataViewAuth;

  /**
   * 最终执行的sql
   */
  private String executeSql;

  /**
   * 统计的sql
   */
  private String executeCountSql;

  /**
   * 包围的sql表别名
   */
  private String wrapperSqlAlias;

  /**
   * 执行sql的参数，此参数接收基本数据类型
   */
  private List<Object> executeSqlParameters;

  /**
   * 执行统计sql的参数，此参数接收基本数据类型
   */
  private List<Object> executeCountSqlParameters;

  /**
   * 预制值的处理类
   */
  private SQLPresetValueAnalysis sqlPresetValueAnalysis;

  public DataSourceTypeEnum getDataSourceType() {
    return dataSourceType;
  }

  public void setDataSourceType(DataSourceTypeEnum dataSourceType) {
    this.dataSourceType = dataSourceType;
  }

  public Set<DataViewSystemEntity> getSystemFilters() {
    return systemFilters;
  }

  public void setSystemFilters(Set<DataViewSystemEntity> systemFilters) {
    this.systemFilters = systemFilters;
  }

  public DataSourceEntity getDataSource() {
    return dataSource;
  }

  public void setDataSource(DataSourceEntity dataSource) {
    this.dataSource = dataSource;
  }

  public DataViewEntity getDataView() {
    return dataView;
  }

  public void setDataView(DataViewEntity dataView) {
    this.dataView = dataView;
  }

  public ExecuteParamModel getExecuteParam() {
    return executeParam;
  }

  public void setExecuteParam(ExecuteParamModel executeParam) {
    this.executeParam = executeParam;
  }

  public DataViewAuthEntity getDataViewAuth() {
    return dataViewAuth;
  }

  public void setDataViewAuth(DataViewAuthEntity dataViewAuth) {
    this.dataViewAuth = dataViewAuth;
  }

  public Set<DataViewFieldEntity> getDataViewFields() {
    return dataViewFields;
  }

  public void setDataViewFields(Set<DataViewFieldEntity> dataViewFields) {
    this.dataViewFields = dataViewFields;
  }

  public Set<DataViewFilterEntity> getDataViewFilters() {
    return dataViewFilters;
  }

  public void setDataViewFilters(Set<DataViewFilterEntity> dataViewFilters) {
    this.dataViewFilters = dataViewFilters;
  }

  public ApplicationContext getApplicationContext() {
    return applicationContext;
  }

  public void setApplicationContext(ApplicationContext applicationContext) {
    this.applicationContext = applicationContext;
  }

  public String getExecuteSql() {
    return executeSql;
  }

  public void setExecuteSql(String executeSql) {
    this.executeSql = executeSql;
  }

  public List<Object> getExecuteSqlParameters() {
    return executeSqlParameters;
  }

  public void setExecuteSqlParameters(List<Object> executeSqlParameters) {
    this.executeSqlParameters = executeSqlParameters;
  }

  public String getExecuteCountSql() {
    return executeCountSql;
  }

  public void setExecuteCountSql(String executeCountSql) {
    this.executeCountSql = executeCountSql;
  }

  public String getWrapperSqlAlias() {
    return wrapperSqlAlias;
  }

  public void setWrapperSqlAlias(String wrapperSqlAlias) {
    this.wrapperSqlAlias = wrapperSqlAlias;
  }

  public SQLPresetValueAnalysis getSqlPresetValueAnalysis() {
    return sqlPresetValueAnalysis;
  }

  public void setSqlPresetValueAnalysis(SQLPresetValueAnalysis sqlPresetValueAnalysis) {
    this.sqlPresetValueAnalysis = sqlPresetValueAnalysis;
  }

  public List<Object> getExecuteCountSqlParameters() {
    return executeCountSqlParameters;
  }

  public void setExecuteCountSqlParameters(List<Object> executeCountSqlParameters) {
    this.executeCountSqlParameters = executeCountSqlParameters;
  }

  public SqlAnalysis getSqlAnalysis() {
    return sqlAnalysis;
  }

  public void setSqlAnalysis(SqlAnalysis sqlAnalysis) {
    this.sqlAnalysis = sqlAnalysis;
  }

  public List<Object> addExecuteSqlParameter(Object obj) {
    if(executeSqlParameters == null) {
      executeSqlParameters = new ArrayList<>();
    }
    executeSqlParameters.add(obj);
    return executeSqlParameters;
  }

  public List<Object> addExecuteCountSqlParameter(Object obj) {
    if(executeCountSqlParameters == null) {
      executeCountSqlParameters = new ArrayList<>();
    }
    executeCountSqlParameters.add(obj);
    return executeCountSqlParameters;
  }

  public List<Object> addExecuteCountSqlParameters(List<Object> parameters) {
    if(executeCountSqlParameters == null) {
      executeCountSqlParameters = new ArrayList<>();
    }
    if(!CollectionUtils.isEmpty(parameters)) {
      executeCountSqlParameters.addAll(parameters);
    }
    return executeCountSqlParameters;
  }

  public String appendExecuteSql(String append) {
    if(executeSql == null) {
      executeSql = "";
    }
    if(append != null) {
      executeSql += append;
    }
    return executeSql;
  }

}
