package com.bizunited.platform.core.service.invoke;

/**
 * 该接口用于承载链式调用过程中，对InvokeRequestHandle链和InvokeResponseFilter链的操作逻辑<br>
 * 目前有两个实现分别是一般情况下使用的DefaultHandleChain以及专门用于groovy脚本链式操作过程的GroovyScriptHandleChain
 * @author yinwenjie
 */
public interface HandleChain {
  
  /**
   * 该枚举表示在处理链上的某一个handle执行结束后的后续处理逻辑：<p>
   * CONTINUE 表示继续进行当前处理链上的下一个处理节点的处理；<br>
   * BREAK 表示本Handler节点处理正常，但是终结当前链上的后续处理节点的处理，进入下一个处理链的执行处理过程；如果当前链是最后的处理链，则整个调用过程完成<br>
   * @author yinwenjie
   */
  public enum ChainLogic {
    CONTINUE , BREAK
  }
  
  /**
   * 调用此方法，调用管理器将进行下一阶段的调用处理。
   * @param context
   * @param chainLogic 指定当前执行过程正常结束后，后续的调用节点如何处理
   * @throws InvokeProxyException 如果抛出一样，那么调用者可以捕获并进行处理，但是如无特别要求请向上继续抛出该异常让对象
   */
  public void doHandle(InvokeProxyContext context , ChainLogic chainLogic) throws InvokeProxyException;
}
