package com.bizunited.platform.core.service.invoke;

/**
 * 服务调用模块的基础异常定义，和java原生异常不同的是，这里携带了上下文信息
 * @author yinwenjie
 */
public class InvokeProxyException extends Exception {
  /**
   * 
   */
  private static final long serialVersionUID = 5747357077602015960L;
  
  /** 
   * 链式调用上下文
   */
  private InvokeProxyContext context;
  
  public InvokeProxyException(InvokeProxyContext context) {
    this.context = context;
  }
  public InvokeProxyException(InvokeProxyContext context , String message) {
    super(message);
    this.context = context;
  }
  public InvokeProxyException(InvokeProxyContext context , String message , Throwable cause) {
    super(message , cause);
    this.context = context;
  }
  public InvokeProxyException(InvokeProxyContext context , Throwable cause) {
    super(cause);
    this.context = context;
  }
  
  public InvokeProxyContext getContext() {
    return context;
  }
}
