package com.bizunited.platform.core.service.invoke.handle.request;

import org.apache.commons.lang3.Validate;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;

import com.bizunited.platform.core.service.invoke.HandleChain;
import com.bizunited.platform.core.service.invoke.HandleChain.ChainLogic;
import com.bizunited.platform.core.service.invoke.InvokeParams;
import com.bizunited.platform.core.service.invoke.InvokeProxyContext;
import com.bizunited.platform.core.service.invoke.InvokeProxyException;
import com.bizunited.platform.core.service.invoke.InvokeRequestHandle;

/**
 * 实际操作者的权限信息过滤,如果没有权限信息，则抛出异常
 * @author yinwenjie
 */
@Component("PrincipalHandle2")
public class PrincipalHandle implements InvokeRequestHandle {  
  /* (non-Javadoc)
   * @see com.bizunited.platform.core.service.invoke.InvokeRequestHandle#doHandle(com.bizunited.platform.core.service.invoke.ServicableContext, com.bizunited.platform.core.service.invoke.HandleChain)
   */
  @Override
  public void doHandle(InvokeProxyContext context, HandleChain chain) throws InvokeProxyException {
    SecurityContext securityContext = SecurityContextHolder.getContext();
    Validate.notNull(securityContext , "未发现任何用户权限信息!!");
    Authentication authentication = securityContext.getAuthentication();
    Validate.notNull(authentication , "未发现任何用户登录信息!!");
    String userName = authentication.getName();
    Validate.notBlank(userName , "非法的访问 ， 操作者权限信息或已过期!!");
    // 存储到上下文中
    InvokeParams invokeParams = context.getParams();
    invokeParams.putInvokeParam("principal", userName);
    // 继续下一个处理节点
    chain.doHandle(context, ChainLogic.CONTINUE);
  }
}