package com.bizunited.platform.core.service.invoke.handle.request;

import java.util.Date;

import org.springframework.stereotype.Component;

import com.bizunited.platform.core.service.invoke.HandleChain;
import com.bizunited.platform.core.service.invoke.InvokeProxyContext;
import com.bizunited.platform.core.service.invoke.InvokeProxyException;
import com.bizunited.platform.core.service.invoke.InvokeRequestHandle;
import com.bizunited.platform.core.service.invoke.HandleChain.ChainLogic;
import com.bizunited.platform.core.service.invoke.InvokeParams;

/**
 * 该计时器是一个通用的ServicableRequestHandle，用来记录代理调用链开始的时间</br>
 * 该事件将被记录到调用上下文中的"_timerRecord"变量中
 * @author yinwenjie
 */
@Component("TimerRecordRequestHandle2")
public class TimerRecordHandle implements InvokeRequestHandle {

  @Override
  public void doHandle(InvokeProxyContext context, HandleChain chain) throws InvokeProxyException {
    Date currentTime = new Date();
    InvokeParams invokeParams = context.getParams();
    
    invokeParams.putInvokeParam("_timerRecord", currentTime);
    chain.doHandle(context, ChainLogic.CONTINUE);
  }
}
