package com.bizunited.platform.core.service.migrate;

import com.bizunited.platform.core.entity.MigrateExportEntity;

import java.util.List;

/**
 * 基础工具套件中的关键数据迁移-迁出服务的定义在这里
 * @author yinwenjie
 */
public interface MigrateExportService {

  /**
   * 保存导出日志
   * @param export
   * @return
   */
  MigrateExportEntity save(MigrateExportEntity export);

  /**
   * 根据数据类型查询导出日志
   * @param dataType
   * @return
   */
  List<MigrateExportEntity> findDetailsByDataType(Integer dataType);

  /**
   * 导出数据视图设计
   * @param ids
   * @return
   */
  byte[] exportDataView(String[] ids);

  /**
   * 导出远端数据源
   * @param ids
   * @return
   */
  byte[] exportRemoteService(String[] ids);

  /**
   * 导出指定编号的业务编码
   * @param codeRuleIds
   * @return
   */
  byte[] exportCodeRule(String[] codeRuleIds);

  /**
   * 导出指定编号的全局变量
   * @param envIds
   * @return
   */
  byte[] exportEnv(String[] envIds);
}
