package com.bizunited.platform.core.service.script.model;

import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * ScriptInputParamsModel
 *
 * @description:
 * @author: yanwe
 * @date: 27/May/2019 16:01
 */
public class ScriptInputParamsModel implements Serializable {

  private static final long serialVersionUID = 4195605414151281212L;

  /**
   * 脚本实体IDS
   */
  private List<String> scriptIds;

  /**
   * 脚本中涉及的参数
   */
  private transient Map<String,Object> params;


  public void setParams(String key , Object value) {
    if(StringUtils.isEmpty(key)){
      return;
    }
    this.params.put(key,value);
  }

  public Object getParams(String key) {
    if(StringUtils.isEmpty(key)){
      return null;
    }
    return this.params.get(key);
  }

  public Set<String> keySet(){
    if(CollectionUtils.isEmpty(this.params)){
      return new HashSet<>();
    }
    return this.params.keySet();
  }

  public Map<String, Object> getParams() {
    return params;
  }

  public List<String> getScriptIds() {
    return scriptIds;
  }

  public void setScriptIds(List<String> scriptIds) {
    this.scriptIds = scriptIds;
  }


}
