package com.bizunited.platform.core.service.serviceable;

import com.alibaba.fastjson.JSONObject;
import com.bizunited.platform.core.service.invoke.InvokeParams;
import com.bizunited.platform.core.service.invoke.InvokeProxyException;
import com.bizunited.platform.core.service.serviceable.model.ServicableMethodInfo;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
/**
 * nebula服务源管理、调用的相关服务定义
 * @author yinwenjie
 */
public interface ServicableMethodService {
  
  /**
   * 添加一个新的表单暴露服务的描述，包括描述中的明细信息
   * @param serviceMethod
   */
  public void create(ServicableMethodInfo serviceMethod);
  
  /**
   * 按照可能的服务源名称、服务源完整接口名、服务源方法简称查询条件，进行服务源信息查询
   * @param pageable
   * @param name 可能的服务源名称 查询条件
   * @param description 方法中文描述（支持模糊查询）
   * @param interfaceName 可能的服务源完整接口名 查询条件
   * @param simpleMethodName 可能的服务源方法简称 查询条件
   * @param returnClassName 可能的返回classname（全名）作为查询条件
   * @param usedScope 服务源方法的应用范围：目前支持：读操作(READ)，写操作(WRITE)
   * @return
   */
  public Page<JSONObject> findByConditions(Pageable pageable, String name, String description, String interfaceName, String simpleMethodName, String returnClassName, String usedScope);
  /**
   * 进行指定的服务源调用（serviceName）——基于调用链上下文中的参数进行。该服务用于支撑服务源的代理调用方式，既是使用者通过调用链的代理器进行调用
   * @param serviceName 指定的服务源的名字，如果没有发现指定的服务源将会报错
   * @param invokeProxyContext 由调用链上层传来的调用链上下文信息
   * @return 进行服务源调用后的返回值
   * @throws InvokeProxyException
   */
  public Object invoke(String serviceName , InvokeParams invokeParams) throws InvokeProxyException;
  /**
   * 进行指定的服务源调用（serviceName）——基于NebulaServiceMethod注解进行的AOP直接调用。
   * @param serviceName 指定的服务源的名字，如果没有发现指定的服务源将会报错
   * @param values 由外部传来的参数信息
   * @return 进行服务源调用后的返回值，如果服务源没有返回值，则返回null
   * @throws InvokeProxyException
   */
  public Object invoke(String serviceName , Object[] values);
  /**
   * 根据name值  查询服务源信息以及该服务源的参数信息等
   * @param name 
   * @return 
   */
  public ServicableMethodInfo findDetailsByName(String name);
  /**
   * 根据name值  查询服务源信息以及该服务源的参数信息
   * @param name
   * @return
   */
  JSONObject findDetailJsonByName(String name);
}
