package com.bizunited.platform.core.service.serviceable.aspect;

import java.lang.reflect.Method;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;

import com.bizunited.platform.core.service.invoke.InvokeProxyBuilder;
import com.bizunited.platform.core.service.invoke.InvokeRequestHandle;
import com.bizunited.platform.core.service.invoke.InvokeResponseHandle;
import com.bizunited.platform.core.service.serviceable.ServicableMethodService;
import com.bizunited.platform.core.service.serviceable.model.ServicableMethodInfo;


public abstract class AbstractNebulaServiceMethodExecution {
  /**
   * 记录当前线程，被基于AOP切面处理方法栈信息
   */
  private ThreadLocal<NebulaServiceMethodExecutionInfo> nebulaServiceMethodExecutionInfo = new ThreadLocal<>();
  
  @Autowired
  private ApplicationContext applicationContext;
  @Autowired
  private ServicableMethodService servicableMethodService;
  
  public void setApplicationContext(ApplicationContext applicationContext) {
    this.applicationContext = applicationContext;
  }

  public void setServicableMethodService(ServicableMethodService servicableMethodService) {
    this.servicableMethodService = servicableMethodService;
  }
  
  /**
   * 根据获取的servicableMethodInfo信息，
   * @param servicableMethodInfo 
   */
  @SuppressWarnings("unchecked")
  protected InvokeProxyBuilder buildInvokeProxy(ServicableMethodInfo servicableMethodInfo) {
    String requestHandleGroup = servicableMethodInfo.getRequestHandleGroup();
    Class<?> requestHandleTypes[] = servicableMethodInfo.getRequestHandleTypes();
    String responseHandleGroup = servicableMethodInfo.getResponseHandleGroup();
    Class<?> responseHandleTypes[] = servicableMethodInfo.getResponseHandleTypes();
    
    // 开始构建InvokeProxy
    InvokeProxyBuilder invokeProxyBuilder = new InvokeProxyBuilder();
    invokeProxyBuilder.addClassLoader(applicationContext.getClassLoader());
    // 可能的requestHandleTypes
    for(int index = 0 ; requestHandleTypes != null && index < requestHandleTypes.length ; index++) {
      Class<InvokeRequestHandle> invokeRequestHandleType = (Class<InvokeRequestHandle>)requestHandleTypes[index];
      invokeProxyBuilder.addInvokeRequestTypeFilter(invokeRequestHandleType);
    }
    // 可能的requestHandleGroup
    if(!StringUtils.isBlank(requestHandleGroup)) {
      Object targetObject = this.applicationContext.getBean(requestHandleGroup);
      InvokeProxyBuilder sourceBuilder = (InvokeProxyBuilder)targetObject;
      invokeProxyBuilder.copy(sourceBuilder);
    }
    // 可能的responeHandleTypes
    for(int index = 0 ; responseHandleTypes != null && index < responseHandleTypes.length ; index++) {
      Class<InvokeResponseHandle> invokeResponseHandleType = (Class<InvokeResponseHandle>)responseHandleTypes[index];
      invokeProxyBuilder.addInvokeResponseTypeFilter(invokeResponseHandleType);
    }
    // 可能的responseHandleGroup
    if(!StringUtils.isBlank(responseHandleGroup)) {
      Object targetObject = this.applicationContext.getBean(responseHandleGroup);
      InvokeProxyBuilder sourceBuilder = (InvokeProxyBuilder)targetObject;
      invokeProxyBuilder.copy(sourceBuilder);
    }
    // 可能的invokeRequestHandleBinding
    invokeProxyBuilder.setInvokeRequestHandleBinding(requestHandleClass -> this.applicationContext.getBean(requestHandleClass));
    // 可能的invokeResponseHandleBinding
    invokeProxyBuilder.setInvokeResponseHandleBinding(responseHandleClass -> this.applicationContext.getBean(responseHandleClass));
    return invokeProxyBuilder;
  }
  
  protected ServicableMethodInfo findByServicableMethodName(String servicableMethodName) {
    return this.servicableMethodService.findDetailsByName(servicableMethodName);
  }
  
  /**
   * 判定当前线程中，是否有AOP Execution跟踪信息
   * @return
   */
  protected boolean isExecutionInfoEmpty() {
    if(this.nebulaServiceMethodExecutionInfo.get() == null) {
      this.nebulaServiceMethodExecutionInfo.set(new NebulaServiceMethodExecutionInfo());
    }
    return this.nebulaServiceMethodExecutionInfo.get().isEmpty();
  }
  
  protected boolean hasExecutionInfo(Method currentMethod) {
    if(this.nebulaServiceMethodExecutionInfo.get() == null) {
      this.nebulaServiceMethodExecutionInfo.set(new NebulaServiceMethodExecutionInfo());
    }
    return this.nebulaServiceMethodExecutionInfo.get().hasMehtod(currentMethod);
  }
  
  protected void pushExecutionInfo(Method currentMethod) {
    if(this.nebulaServiceMethodExecutionInfo.get() == null) {
      this.nebulaServiceMethodExecutionInfo.set(new NebulaServiceMethodExecutionInfo());
    }
    this.nebulaServiceMethodExecutionInfo.get().push(currentMethod);
  }
  
  protected void popExecutionInfo() {
    if(this.nebulaServiceMethodExecutionInfo.get() == null) {
      this.nebulaServiceMethodExecutionInfo.set(new NebulaServiceMethodExecutionInfo());
    }
    this.nebulaServiceMethodExecutionInfo.get().pop();
  }
}
