package com.bizunited.platform.core.service.serviceable.aspect;

import java.lang.reflect.Method;
import java.util.ArrayDeque;

import org.apache.commons.lang3.Validate;

/**
 * TODO 注释未写
 * @author yinwenjie
 */
public class NebulaServiceMethodExecutionInfo {
  /**
   * 当前正在被AOP拦截执行的方法信息
   */
  private ArrayDeque<Method> currentExecutionMethods = new ArrayDeque<>();
  
  /**
   * 判定当前执行栈中，给定的方法信息是否在执行中
   * @param method 指定的方法信息
   * @return
   */
  public boolean hasMehtod(Method method) {
    return this.currentExecutionMethods.contains(method);
  }
  
  /**
   * 将指定的方法信息加入到AOP代理器正在执行的方法信息栈中，如果存在重复的情况，将会报错
   * @param method 指定的方法信息
   * @return
   */
  public void push(Method method) {
    Validate.isTrue(!this.currentExecutionMethods.contains(method) , "基于业务逻辑安全性考虑，服务源调用过程不支持单元递归或多元递归方式，请检查调用逻辑!!");
    this.currentExecutionMethods.push(method);
  }
  
  public boolean isEmpty() {
    return this.currentExecutionMethods.isEmpty();
  }
  
  /**
   * 将栈中已完成AOP处理过程的方法信息描述进行移除
   * @param method 指定的方法信息
   * @return
   */
  public Method pop() {
    return this.currentExecutionMethods.pop();
  }
}