package com.bizunited.platform.core.service.serviceable.handle;

import org.aspectj.lang.ProceedingJoinPoint;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.bizunited.platform.core.service.invoke.HandleChain;
import com.bizunited.platform.core.service.invoke.InvokeParams;
import com.bizunited.platform.core.service.invoke.InvokeProxyContext;
import com.bizunited.platform.core.service.invoke.InvokeProxyException;
import com.bizunited.platform.core.service.invoke.InvokeRequestHandle;
import com.bizunited.platform.core.service.invoke.HandleChain.ChainLogic;
import com.bizunited.platform.core.service.serviceable.ServicableMethodService;

/**
 * 基于调用链工作的服务源调用器
 * @author yinwenjie
 */
@Component("ServiceMethodExecutionHandle")
public class ServiceMethodExecutionHandle implements InvokeRequestHandle {
  @Autowired
  private ServicableMethodService servicableMethodService;
  
  /**
   * 可能使用的服务名
   */
  public static final String SERVER_NAME_PARAM = "_service_name_";
  
  /**
   * 可能使用的切面点
   */
  public static final String SERVER_AOP_POINT = "_server_aop_point_";
  
  @Override
  public void doHandle(InvokeProxyContext context, HandleChain chain) throws InvokeProxyException {
    InvokeParams  invokeParams = context.getParams();
    Object[] args = invokeParams.getVariables();
    Object result = null;
    
    /*
     * 优先使用切面点直接进行方法调用
     * 如果没有切面点信息，在进行基于servicableMethodService的代理调用
     * */
    if(invokeParams.getInvokeParam(SERVER_AOP_POINT) != null) {
      ProceedingJoinPoint point = (ProceedingJoinPoint)invokeParams.getInvokeParam(SERVER_AOP_POINT);
      try {
        result = point.proceed(args);
      } catch (Throwable e) {
        throw new IllegalArgumentException(e);
      }
    } else {
      String serviceName = invokeParams.getInvokeParam(SERVER_NAME_PARAM).toString();
      // 调用并记录返回值
      result = this.servicableMethodService.invoke(serviceName, args);
    }
    context.setResult(result);
    chain.doHandle(context, ChainLogic.CONTINUE);
  }
}
