package com.bizunited.platform.core.service.serviceable.model;

import java.lang.reflect.Parameter;

import com.bizunited.platform.core.service.serviceable.template.ValueMappingTemplate;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * nebula业务构建平台服务源方法详细属性描述
 * @author yinwenjie
 * @since V2.2+
 */
@ApiModel(value = "ServicableMethodProperty" , description="nebula业务构建平台服务源方法详细属性描述")
public class ServicableMethodProperty {
  /**
   * 参数的索引号，0表示第一个位置的参数。注意index的顺序不一定连续，这是因为有一些参数不一定在调用时传入
   */
  @ApiModelProperty(name="propertyIndex" , value="参数的索引号，0表示第一个位置的参数。注意index的顺序不一定连续，这是因为有一些参数不一定在调用时传入")
  private Integer propertyIndex;
  /**
   * 参数类型：集服务源方法的原始参数类型
   */
  @ApiModelProperty(name="paramType" , value="参数类型")
  private Parameter parameter;
  /**
   * ServiceMethodParam
   */
  @ApiModelProperty(name="hasParamAnnotation" , value="当前参数是否有ServiceMethodParam注解")
  private boolean hasParamAnnotation;
  /**
   * 参数限定名，只有在当前参数拥有ServiceMethodParam注解时，当前值才有且一定有值
   */
  @ApiModelProperty(name="annonQualifiedName" , value="参数限定名，只有在当前参数拥有ServiceMethodParam注解时，当前值才有且一定有值")
  private String annonQualifiedName;
  /**
   * 该参数进行值映射使用的映射处理器
   */
  @ApiModelProperty(name="valueMappingTemplate" , value="该参数进行值映射使用的映射处理器")
  private ValueMappingTemplate valueMappingTemplate;
  
  public Integer getPropertyIndex() {
    return propertyIndex;
  }
  public void setPropertyIndex(Integer propertyIndex) {
    this.propertyIndex = propertyIndex;
  }
  public Parameter getParamType() {
    return parameter;
  }
  public void setParamType(Parameter paramType) {
    this.parameter = paramType;
  }
  public boolean isHasParamAnnotation() {
    return hasParamAnnotation;
  }
  public void setHasParamAnnotation(boolean hasParamAnnotation) {
    this.hasParamAnnotation = hasParamAnnotation;
  }
  public String getAnnonQualifiedName() {
    return annonQualifiedName;
  }
  public void setAnnonQualifiedName(String annonQualifiedName) {
    this.annonQualifiedName = annonQualifiedName;
  }
  public ValueMappingTemplate getValueMappingTemplate() {
    return valueMappingTemplate;
  }
  public void setValueMappingTemplate(ValueMappingTemplate valueMappingTemplate) {
    this.valueMappingTemplate = valueMappingTemplate;
  }
}
