package com.bizunited.platform.core.service.serviceable.template;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;

import com.alibaba.fastjson.JSONObject;

/**
 * 由于存在多个对json-抽象对象处理的模板类，所以需要有一个抽象类来管理它们共用的一些方法
 * @author Administrator
 */
public abstract class AbstractObjectValueMappingTemplate implements ValueMappingTemplate {
  /**
   * 日志
   */
  private static final  Logger LOGGER = LoggerFactory.getLogger(AbstractObjectValueMappingTemplate.class);
  @Autowired
  private ApplicationContext applicationContext;
  
  /**
   * 正式进行json-object的值映射处理
   * @param jsonObject
   * @param parameterClass
   * @return
   */
  protected Object mappingObject(JSONObject jsonObject , Class<?> parameterClass) {
    String className = parameterClass.getName();
    
    // ===== 试图取得正确的class，并转换
    Object result = null;
    try {
      result = JSONObject.parseObject(jsonObject.toJSONString(), parameterClass);
    } catch(RuntimeException e) {
      LOGGER.warn(e.getMessage());
    }
    if(result != null) {
      return result;
    }
    // 使用当前线程的ClassLoader进行取数
    ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
    try {
      parameterClass = classLoader.loadClass(className);
      result = JSONObject.parseObject(jsonObject.toJSONString(), parameterClass);
    } catch(ClassNotFoundException | RuntimeException e) {
      LOGGER.warn(e.getMessage());
    }
    if(result != null) {
      return result;
    }
    // 使用spring上线文使用的ClassLoader进行取数
    classLoader = applicationContext.getClassLoader();
    try {
      parameterClass = classLoader.loadClass(className);
      result = JSONObject.parseObject(jsonObject.toJSONString(), parameterClass);
    } catch(ClassNotFoundException e) {
      LOGGER.error(e.getMessage() , e);
    }
    return result;
  }
}
