package com.bizunited.platform.core.service.serviceable.template;

import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Date;

import org.apache.commons.lang3.Validate;
import org.springframework.stereotype.Component;

import com.bizunited.platform.core.service.invoke.InvokeParams;

/**
 * 处理Date类型和其子类的类转换和值映射
 * @author yinwenjie
 */
@Component
public class DateValueMappingTemplate implements ValueMappingTemplate {

  @Override
  public boolean match(Class<?> targetClass, Method targetMethod, Parameter parameter, int index) {
    Class<?> parameterType = parameter.getType();
    boolean isArray = parameterType.isArray();
    
    // 写成两个if条件，主要实在逻辑上好进行管理和区分
    // 如果join-point入参不是数组，且当前入参类型为Date类型，则该值映射模板支持映射体系
    if(!isArray && Date.class.isAssignableFrom(parameterType)) {
      Validate.isTrue(this.checkServiceMethodParamAnnotation(parameter) , "设定服务源时Date日期类型的参数[%s]，必须携带ServiceMethodParam注解" , targetMethod.toString());
      return true;
    }
    // 如果join-point入参是数组，且当前入参原始类型为Date类型，则该值映射模板支持映射体系
    if(isArray && Date.class.isAssignableFrom(parameterType.getComponentType())) {
      Validate.isTrue(this.checkServiceMethodParamAnnotation(parameter) , "设定服务源时Date日期类型的参数[%s]，必须携带ServiceMethodParam注解" , targetMethod.toString());
      return true;
    }
    
    return false;
  }

  @Override
  public Object mapping(Class<?> targetComponentType, Method targetMethod, Parameter parameter, int index, String parameterName , InvokeParams invokeParams) {
    // TODO 未完成，后续完成
    return null;
  }
  
}
