package com.bizunited.platform.core.service.serviceable.template;

import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Map;

import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import com.alibaba.fastjson.JSONObject;
import com.bizunited.platform.core.service.invoke.InvokeParams;

/**
 * 处理Pageable类型的类转换和值映射（这个信息，主要就是外部调用要求的分页信息）
 * @author yinwenjie 
 */
@Component
public class PageableValueMappingTemplate implements ValueMappingTemplate {

  @Override
  public boolean match(Class<?> targetClass, Method targetMethod, Parameter parameter, int index) {
    Class<?> parameterType = parameter.getType();
    boolean isArray = parameterType.isArray();
    
    // 不能是数组
    if(isArray) {
      return false;
    }
    // 参数类型必须是Pageable
    if(Pageable.class.isAssignableFrom(parameterType)) {
      return true;
    }
    
    return false;
  }

  @SuppressWarnings("unchecked")
  @Override
  public Object mapping(Class<?> targetComponentType, Method targetMethod, Parameter parameter, int index , String parameterName , InvokeParams invokeParams) {
    Object value = invokeParams.getInvokeParam(parameterName);
    if(value == null) {
      return null;
    }
    
    // 进行分页请求值的处理
    if(Map.class.isAssignableFrom(value.getClass())) {
      Map<String , Object> pageMapping = (Map<String , Object>)value;
      Integer page = (Integer)pageMapping.get("page");
      if(page == null) {
        page = 0;
      }
      Integer size = (Integer)pageMapping.get("size");
      if(size == null) {
        size = 50;
      }
      // 可能的sort信息
      Object sorts = pageMapping.get("sort");
      if(sorts != null && sorts instanceof Map) {
        // TODO 排序信息处理
      }
      return PageRequest.of(page, size);
    } else if(value instanceof JSONObject){
      JSONObject valueJson = (JSONObject)value;
      return JSONObject.toJavaObject(valueJson, PageRequest.class);
    }
    
    throw new IllegalArgumentException("分页情况描述Pageable，json格式不正确，请检查");
  }
}
