package com.bizunited.platform.core.service.serviceable.template;

import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.time.temporal.Temporal;

import org.springframework.stereotype.Component;

import com.bizunited.platform.core.service.invoke.InvokeParams;

/**
 * 处理Temporal类型和其子类的类转换和值映射。Temporal是java中推荐的新的时间、日期处理类的顶层接口</br>
 * @author yinwenjie
 */
@Component
public class TemporalValueMappingTemplate implements ValueMappingTemplate {

  @Override
  public boolean match(Class<?> targetClass, Method targetMethod, Parameter parameter, int index) {
    Class<?> parameterType = parameter.getType();
    boolean isArray = parameterType.isArray();
    
    // 写成两个if条件，主要实在逻辑上好进行管理和区分
    // 如果join-point入参不是数组，且当前入参类型为Temporal类型，则该值映射模板支持映射体系
    if(!isArray && Temporal.class.isAssignableFrom(parameterType)) {
      return true;
    }
    // 如果join-point入参是数组，且当前入参原始类型为Temporal类型，则该值映射模板支持映射体系
    if(isArray && Temporal.class.isAssignableFrom(parameterType.getComponentType())) {
      return true;
    }
    
    return false;
  }

  @Override
  public Object mapping(Class<?> targetComponentType, Method targetMethod, Parameter parameter, int index , String parameterName , InvokeParams invokeParams) {
    // TODO 未完成，后续完成
    return null;
  }
}