package com.bizunited.platform.core.annotations;

import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;

/**
 * 该注解用于区分哪些是暴露方法中需要指定的参数
 * 目前版本的传参支持String等基础类型，Map，表单formData数据，Principal，Pageable：</p>
 * 1.当参数有两个相同的基础类型时,需要指定注解</br>
 * 2.当参数有多个formData类型的数据时,抛出异常提示信息</br>
 * 3.其他情况不用显示指定参数注解</br>
 */
@Retention(value = java.lang.annotation.RetentionPolicy.RUNTIME)
@Target(value = {java.lang.annotation.ElementType.PARAMETER })
@Documented
public @interface ServiceMethodParam {
  String name();
}
