package com.bizunited.platform.core.aspect;

import com.bizunited.platform.common.service.NebulaToolkitService;
import com.bizunited.platform.core.entity.log.LoggerTemplateEntity;
import com.bizunited.platform.core.service.LoggerInfoEntityService;
import com.bizunited.platform.core.service.LoggerTemplateEntityService;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Lazy;

import java.lang.reflect.Method;

/**
 * nebula日志功能的原生切面逻辑
 * @author yinwenjie
 */
public class  AnnotationLoggerAspect {
  @Autowired
  @Lazy
  private LoggerTemplateEntityService loggerTemplateService;
  @Autowired
  @Lazy
  private NebulaLoggerHandle nebulaLoggerHandle;

  /**
   * 任何工作在项目包下的方法都要使用该切面
   */
//  @Pointcut("@within(org.springframework.stereotype.Controller) "
//      + " or @within(org.springframework.web.bind.annotation.RestController) "
//      + " or @within(org.springframework.stereotype.Service) "
//      + " or @within(org.springframework.stereotype.Component) ")
  public void aspectHandle() {

  }

  /**
   * 只有在日志模板中有相关设定的方法，才会被本AOP代理，其它的全部放行
   * @param point
   * @return
   */
  @Around(value="aspectHandle()")
  public Object around(ProceedingJoinPoint point) {
    if(loggerTemplateService == null || nebulaLoggerHandle == null) {
      return this.ignoreProcess(point);
    }
    Signature signature = point.getSignature();
    if(!(signature instanceof MethodSignature)) {
      return this.ignoreProcess(point);
    }
    MethodSignature methodSignature = (MethodSignature)signature;
    Method targetMethod = methodSignature.getMethod();
    String methodName = targetMethod.getName();
    Class<?> declaringClass = targetMethod.getDeclaringClass();
    String className = declaringClass.getName();
    String fullMethodName = StringUtils.join(className , "." , methodName);
    // 这里要做loggerTemplateService等服务的定向剔除
    if(LoggerTemplateEntityService.class.isAssignableFrom(declaringClass)
            || NebulaToolkitService.class.isAssignableFrom(declaringClass)
            || LoggerInfoEntityService.class.isAssignableFrom(declaringClass)
            || ApplicationContext.class.isAssignableFrom(declaringClass)) {
      return this.ignoreProcess(point);
    }
    LoggerTemplateEntity target = this.loggerTemplateService.findByMethodName(fullMethodName);
    if(target == null) {
      return this.ignoreProcess(point);
    }

    // 如果代码进行到这个位置，说明要受到日志记录的管控了
    return this.nebulaLoggerHandle.handLogger(methodSignature, target, point);
  }

  private Object ignoreProcess(ProceedingJoinPoint point) {
    Object obj = null;
    try {
      obj = point.proceed(point.getArgs());
    } catch (RuntimeException | Error ex) {
      throw ex;
    } catch (Throwable thr) {
      Rethrower.rethrow(thr);
    }
    return obj;
  }

  /**
   * 重新抛出异常
   */
  private static class Rethrower {
    public static void rethrow(final Throwable exception) {
      class CheckedExceptionRethrower<T extends Throwable> {
        @SuppressWarnings("unchecked")
        private void rethrow(Throwable exception) throws T {
          throw (T) exception;
        }
      }
      new CheckedExceptionRethrower<RuntimeException>().rethrow(exception);
    }
  }
}
