package com.bizunited.platform.core.common;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

/**
 * 平台上下文工具
 * @author yinwenjie
 */
@Component("PlatformContext")
public class PlatformContext {

  /**
   * 技术中台实例是否成功启动了kuiper表单引擎子系统
   */
  private boolean enableKuiper = false;
  
  /**
   * 技术中台实例是否成功启动了titan流程引擎子系统
   */
  private boolean enableTitan = false;

  /**
   * 技术中台实例是否成功启动了solar服务治理子系统
   */
  private boolean enableSolar = false;

  /**
   * 当前应用名称，此应用名称目前可应用到对表单引擎、列表引擎的项目筛选
   */
  @Value("${nebula.appName:}")
  private String appName;

  /**
   * 技术中台实例是否成功启动了kuiper表单引擎子系统
   * @return
   */
  public boolean isEnableKuiper() {
    return enableKuiper;
  }

  public void setEnableKuiper(boolean enableKuiper) {
    this.enableKuiper = enableKuiper;
  }

  /**
   * 技术中台实例是否成功启动了titan流程引擎子系统
   * @return
   */
  public boolean isEnableTitan() {
    return enableTitan;
  }

  public void setEnableTitan(boolean enableTitan) {
    this.enableTitan = enableTitan;
  }

  /**
   * 技术中台实例是否成功启动了solar服务治理子系统
   * @return
   */
  public boolean isEnableSolar() {
    return enableSolar;
  }

  public void setEnableSolar(boolean enableSolar) {
    this.enableSolar = enableSolar;
  }

  public String getAppName() {
    return appName;
  }

  public void setAppName(String appName) {
    this.appName = appName;
  }
}