package com.bizunited.platform.core.common.enums;

/**
 * 权限类型
 *  * 1.用户
 *    * 2.角色
 *    * 3.岗位
 *    * 4.用户组
 *    * 5.组织机构
 * @Author: Paul Chan
 * @Date: 2020-04-26 17:50
 */
public enum AuthTypeEnum {
  USER(1),
  ROLE(2),
  POSITION(3),
  GROUP(4),
  ORG(5);

  private Integer type;

  AuthTypeEnum(Integer type) {
    this.type = type;
  }

  public Integer getType() {
    return type;
  }

  public static AuthTypeEnum valueOfType(Integer type) {
    if(type == null) {
      return null;
    }
    for (AuthTypeEnum value : AuthTypeEnum.values()) {
      if(value.type.equals(type)) {
        return value;
      }
    }
    return null;
  }

}
