package com.bizunited.platform.core.common.enums;

import org.apache.commons.lang3.StringUtils;

/**
 * sql操作符的相关枚举类
 * NEQ不等于   EQ等于   GT大于   LT小于   GE大于等于   LE小于等于   NULL(is null)   NOTNULL(is not null)
 * LC_RC全闭区间(大于等于 到 小于等于)   LO_RC左开右闭区间(大于 到 小于等于)    LO_RO全开区间(大于 到 小于)    LC_RO左闭右开区间(大于等于 到 小于)
 * BETWEEN全闭区间比较   IN包含   NIN不包含   DISTINCT去重复(注：在一个不包含子查询和union操作的SELECT SQL中只能出现一次)
 * @Author: Paul Chan
 * @Date: 2020-04-21 17:17
 */
public enum SqlOperatorEnum {
  NEQ("!="),
  EQ("="),
  GT(">"),
  LT("<"),
  GE(">="),
  LE("<="),
  NULL("IS NULL"),
  NOTNULL("IS NOT NULL"),
  LC_RC("LC_RC"),
  LO_RC("LO_RC"),
  LO_RO("LO_RO"),
  LC_RO("LC_RO"),
  BETWEEN("BETWEEN"),
  IN("IN"),
  NIN("NOT IN"),
  LLIKE("LLIKE"),
  RLIKE("RLIKE"),
  LIKE("LIKE"),
  DISTINCT("DISTINCT");

  private String oprtValue;

  SqlOperatorEnum(String oprtValue) {
    this.oprtValue = oprtValue;
  }

  public String getOprtValue() {
    return oprtValue;
  }

  public static String getOprtValue(String code) {
    for(SqlOperatorEnum element : SqlOperatorEnum.values()) {
      if(StringUtils.endsWithIgnoreCase(element.name(), code)) {
        return element.oprtValue;
      }
    }
    return null;
  }

}
