package com.bizunited.platform.core.configuration;

import com.bizunited.platform.core.repository.dynamic.DynamicDataSourceManager;
import com.bizunited.platform.core.repository.dynamic.DynamicDataSourceThreadFactory;
import com.bizunited.platform.core.repository.dynamic.DynamicDataSourceThreadPoolExecutor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableAsync;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor.AbortPolicy;
import java.util.concurrent.TimeUnit;

/**
 * 测试线程池的集成（由于在任务开始和结束需要做特别处理，所以使用java原生线程池）
 * @author yinwenjie
 */
@Configuration
@EnableAsync
public class DynamicDataSourceExecutorConfig {
  /**
   * 动态数据源管理器
   */
  @Autowired
  private DynamicDataSourceManager dynamicDataSourceManager;
  
  @Bean("dynamicExecutor")
  public Executor getcExecutor() {
    // 核心线程数
    int corePoolSize = 2;
    // 最大线程数
    int maximumPoolSize = 10;
    // 多余闲置线程等待时间
    int keepAliveTime = 120;
    TimeUnit timeUnit = TimeUnit.SECONDS;
    // 处理队列
    BlockingQueue<Runnable> workQueue = new ArrayBlockingQueue<>(100);
    // 线程创建工厂
    DynamicDataSourceThreadFactory threadFactory = new DynamicDataSourceThreadFactory(this.dynamicDataSourceManager);
    // 拒绝策略
    RejectedExecutionHandler rejectedExecutionHandler = new AbortPolicy();
    
    return new DynamicDataSourceThreadPoolExecutor(corePoolSize, maximumPoolSize, keepAliveTime, timeUnit, workQueue, threadFactory, rejectedExecutionHandler);
    
  }
}
