package com.bizunited.platform.core.controller;

import com.bizunited.platform.common.controller.BaseController;
import com.bizunited.platform.common.controller.model.ResponseModel;
import com.bizunited.platform.core.entity.log.LoggerFiledMappingEntity;
import com.bizunited.platform.core.service.LoggerFiledMappingEntityService;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.*;

/**
 * LoggerFiledMappingEntity业务模型的MVC Controller层实现，基于HTTP Restful风格
 * @author saturn
 */
@RestController
@RequestMapping("/v1/loggerFiledMappingEntitys")
public class LoggerFiledMappingEntityController extends BaseController {
  /**
   * 日志
   */
  private static final Logger LOGGER = LoggerFactory.getLogger(LoggerFiledMappingEntityController.class);
  
  @Autowired
  private LoggerFiledMappingEntityService loggerFiledMappingEntityService;

  /**
   * 相关的创建过程，http接口。请注意该创建过程除了可以创建loggerFiledMappingEntity中的基本信息以外，还可以对loggerFiledMappingEntity中属于OneToMany关联的明细信息一同进行创建注意：基于（LoggerFiledMappingEntity）模型的创建操作传入的loggerFiledMappingEntityJSON对象，其主键信息不能有值，服务端将会自动为其赋予相关值。另外，创建操作成功后，系统将返回该对象的基本信息（不包括任何关联信息）
   * */
  @ApiOperation(value = "相关的创建过程，http接口。请注意该创建过程除了可以创建loggerFiledMappingEntity中的基本信息以外，还可以对loggerFiledMappingEntity中属于OneToMany关联的明细信息一同进行创建注意：基于（LoggerFiledMappingEntity）模型的创建操作传入的loggerFiledMappingEntityJSON对象，其主键信息不能有值，服务端将会自动为其赋予相关值。另外，创建操作成功后，系统将返回该对象的基本信息（不包括任何关联信息）")
  @PostMapping(value="")
  public ResponseModel create(@RequestBody @ApiParam(name="loggerFiledMappingEntity" , value="相关的创建过程，http接口。请注意该创建过程除了可以创建loggerFiledMappingEntity中的基本信息以外，还可以对loggerFiledMappingEntity中属于OneToMany关联的明细信息一同进行创建注意：基于（LoggerFiledMappingEntity）模型的创建操作传入的loggerFiledMappingEntityJSON对象，其主键信息不能有值，服务端将会自动为其赋予相关值。另外，创建操作成功后，系统将返回该对象的基本信息（不包括任何关联信息）") LoggerFiledMappingEntity loggerFiledMappingEntity) {
    try {
      LoggerFiledMappingEntity current = this.loggerFiledMappingEntityService.create(loggerFiledMappingEntity);
      return this.buildHttpResultW(current, new String[]{});
    } catch(RuntimeException e) {
      LOGGER.error(e.getMessage() , e);
      return this.buildHttpResultForException(e);
    }
  }

  /**
   * 相关的更新过程，http接口。请注意该更新过程只会更新在模型层被标记为了updateable的属性，包括一般属性、ManyToOne和OneToOne性质的关联属性，而ManyToMany、OneToMany的关联属性，虽然也会传入，但需要开发人员自行在Service层完善其更新过程注意：基于模型（LoggerFiledMappingEntity）的修改操作传入的loggerFiledMappingEntityJSON对象，其主键信息必须有值，服务端将验证这个主键值是否已经存在。另外，创建操作成功后，系统将返回该对象的基本信息（不包括任何关联信息）
   * */
  @ApiOperation(value = "相关的更新过程，http接口。请注意该更新过程只会更新在模型层被标记为了updateable的属性，包括一般属性、ManyToOne和OneToOne性质的关联属性，而ManyToMany、OneToMany的关联属性，虽然也会传入，但需要开发人员自行在Service层完善其更新过程注意：基于模型（LoggerFiledMappingEntity）的修改操作传入的loggerFiledMappingEntityJSON对象，其主键信息必须有值，服务端将验证这个主键值是否已经存在。另外，创建操作成功后，系统将返回该对象的基本信息（不包括任何关联信息）")
  @PatchMapping(value="")
  public ResponseModel update(@RequestBody @ApiParam(name="loggerFiledMappingEntity" , value="相关的更新过程，http接口。请注意该更新过程只会更新在模型层被标记为了updateable的属性，包括一般属性、ManyToOne和OneToOne性质的关联属性，而ManyToMany、OneToMany的关联属性，虽然也会传入，但需要开发人员自行在Service层完善其更新过程注意：基于模型（LoggerFiledMappingEntity）的修改操作传入的loggerFiledMappingEntityJSON对象，其主键信息必须有值，服务端将验证这个主键值是否已经存在。另外，创建操作成功后，系统将返回该对象的基本信息（不包括任何关联信息）") LoggerFiledMappingEntity loggerFiledMappingEntity) {
    try {
      LoggerFiledMappingEntity current = this.loggerFiledMappingEntityService.update(loggerFiledMappingEntity);
      return this.buildHttpResultW(current, new String[]{});
    } catch(RuntimeException e) {
      LOGGER.error(e.getMessage() , e);
      return this.buildHttpResultForException(e);
    }
  }

  /**
   * 根据LoggerFiledMappingEntity (applicationName、fieldName、fieldDesc)进行分页查询
   * @param loggerFiledMappingEntity 日志字段描述映射
   */
  @ApiOperation(value = "根据LoggerFiledMappingEntity (applicationName、fieldName、fieldDesc)进行分页查询")
  @RequestMapping(value="/findByConditions" , method={RequestMethod.GET})
  public ResponseModel findByConditions( @ApiParam("日志字段描述映射") LoggerFiledMappingEntity loggerFiledMappingEntity,
                                         @PageableDefault(value = 50) @ApiParam("分页参数，当指定page时为查询当前页码（页码从0开始）；当指定size时，为指定每页大小，默认为50") Pageable pageable) {
    try {
      Page<LoggerFiledMappingEntity> result = this.loggerFiledMappingEntityService.findByConditions(loggerFiledMappingEntity,pageable);
      return this.buildHttpResultW(result, new String[]{});
    } catch(RuntimeException e) {
      LOGGER.error(e.getMessage() , e);
      return this.buildHttpResultForException(e);
    }
  }

} 
