package com.bizunited.platform.core.controller;

import com.bizunited.platform.common.controller.BaseController;
import com.bizunited.platform.common.controller.model.ResponseModel;
import com.bizunited.platform.core.entity.log.LoggerInfoEntity;
import com.bizunited.platform.core.service.LoggerInfoEntityService;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * 操作日志业务的MVC Controller层实现，基于HTTP Restful风格
 * @author yinwenjie
 */
@RestController
@RequestMapping("/v1/loggerInfos")
public class LoggerInfoEntityController extends BaseController { 
  /**
   * 日志
   */
  private static final Logger LOGGER = LoggerFactory.getLogger(LoggerInfoEntityController.class);
  
  @Autowired
  private LoggerInfoEntityService loggerInfoEntityService;
  
  @ApiOperation(value = "按照指定的模块和操作业务编号，查询符合条件的日志信息，并按照日志事件进行倒序排列")
  @RequestMapping(value="/findByOpidAndModule" , method={RequestMethod.GET})
  public ResponseModel findByOpidAndModule(@RequestParam("opid") @ApiParam(name="opid" , value="指定的业务编号") String opid ,
                                           @RequestParam("module") @ApiParam(name="module" , value="指定的业务模块信息") String module,
                                           @PageableDefault(value = 50) @ApiParam("分页参数，当指定page时为查询当前页码（页码从0开始）；当指定size时，为指定每页大小，默认为50") Pageable pageable) {
    try { 
      Page<LoggerInfoEntity> result = this.loggerInfoEntityService.findByOpidAndModule(opid, module, pageable);
      return this.buildHttpResultW(result,"");
    } catch(RuntimeException e) {
      LOGGER.error(e.getMessage() , e);
      return this.buildHttpResultForException(e);
    } 
  }
} 
