package com.bizunited.platform.core.controller.vcode;

import com.bizunited.platform.common.controller.BaseController;
import com.bizunited.platform.rbac.server.service.ccode.CheckCodeService;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

/**
 * 和校验码有关的http层服务，由该类进行实现
 * @author yinwenjie
 */
@RestController
@RequestMapping("/v1/nebula/checkCodes")
public class CheckCodeController extends BaseController {
  @Autowired
  private CheckCodeService checkCodeService;
  /**
   * 日志
   */
  private static final Logger LOGGER = LoggerFactory.getLogger(CheckCodeController.class);
  
  @ApiOperation(value = "为当前指定用户标识的登录操作，生成一个新的校验码，并将校验码图片进行返回（png格式）" ,
      notes = "校验码充最后一次调用该方法生成开始计算有5分钟超时时间")
  @PostMapping("")
  public void generate(HttpServletRequest request , HttpServletResponse response ,
                       @RequestParam(name = "width" , required = false) @ApiParam(name = "width", required = false, value = "验证码图片的宽度（单位像素）") Integer width,
                       @RequestParam(name = "height" , required = false) @ApiParam(name = "height", required = false , value = "验证码图片的高度（单位像素）") Integer height) {
    int currentWidth;
    int currentHeight;
    if(width == null || width <= 0) {
      currentWidth = 150;
    } else {
      currentWidth = width;
    }
    if(height == null || height <= 0) {
      currentHeight = 50;
    } else {
      currentHeight = height;
    }
    
    try {
      // 确定当前http请求回话
      HttpSession session = request.getSession();
      String userid = session.getId();
      LOGGER.info("当前session id = {}", userid);
      byte[] contents = this.checkCodeService.generate(userid, 4, currentWidth, currentHeight);
      this.writeResponseFile(response, 1, contents);
    } catch(RuntimeException e) {
      LOGGER.error(e.getMessage() , e);
    }
  }
}